/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.validation.EtsiUComponent;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.BaselineRequirementsChecker;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESBaselineRequirementsChecker
extends BaselineRequirementsChecker<JAdESSignature> {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESBaselineRequirementsChecker.class);
    private static final Date SIG_T_OBSOLESCENCE_DATE = DSSUtils.getUtcDate(2025, 6, 15);

    public JAdESBaselineRequirementsChecker(JAdESSignature signature, CertificateVerifier offlineCertificateVerifier) {
        super(signature, offlineCertificateVerifier);
    }

    @Override
    public boolean hasBaselineBProfile() {
        JWS jws = ((JAdESSignature)this.signature).getJws();
        JAdESEtsiUHeader etsiUHeader = ((JAdESSignature)this.signature).getEtsiUHeader();
        if (Utils.isStringEmpty(jws.getProtectedHeaderValueAsString("alg"))) {
            LOG.warn("alg header shall be present for JAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (((JAdESSignature)this.signature).isCounterSignature() && Utils.isStringNotEmpty(jws.getProtectedHeaderValueAsString("cty"))) {
            LOG.warn("cty header shall not be present for a JAdES-BASELINE-B counter signature!");
            return false;
        }
        if (!this.critRequirements(jws)) {
            return false;
        }
        if (!this.signingTimeRequirement(jws)) {
            return false;
        }
        int certHeaders = 0;
        if (Utils.isStringNotEmpty(jws.getProtectedHeaderValueAsString("x5t#S256"))) {
            ++certHeaders;
        }
        if (Utils.isMapNotEmpty(jws.getProtectedHeaderValueAsMap("x5t#o"))) {
            ++certHeaders;
        }
        if (Utils.isCollectionNotEmpty(jws.getProtectedHeaderValueAsList("sigX5ts"))) {
            ++certHeaders;
        }
        if (certHeaders != 1) {
            LOG.warn("One and only one of x5t#256, x5t#o, sigX5ts headers shall be present for JAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (DSSJsonUtils.getUnsignedPropertiesWithHeaderName(etsiUHeader, "sigPSt").size() > 1) {
            LOG.warn("Only one sigPSt header shall be present for JAdES-BASELINE-B signature (cardinality 0 or 1)!");
            return false;
        }
        if (!this.isSignaturePolicyIdentifierHashPresent() && ((JAdESSignature)this.signature).getSignaturePolicyStore() != null) {
            LOG.warn("sigPSt header shall not be incorporated for JAdES-BASELINE-B signature with not defined sigPId/hashAV (requirement (b))!");
            return false;
        }
        return true;
    }

    private boolean critRequirements(JWS jws) {
        List critList = new ArrayList();
        Object crit = jws.getHeaders().getObjectHeaderValue("crit");
        if (crit != null) {
            if (!(crit instanceof List)) {
                LOG.warn("crit header shall be an instance of json array type for a JAdES-BASELINE-B signature!");
                return false;
            }
            critList = (List)crit;
            if (Utils.isCollectionEmpty(critList)) {
                LOG.warn("crit header shall not be empty for a JAdES-BASELINE-B signature (see RFC 7515)!");
                return false;
            }
            HashSet uniqueEntries = new HashSet();
            Set duplicates = critList.stream().filter(e -> !uniqueEntries.add(e)).collect(Collectors.toSet());
            if (Utils.isCollectionNotEmpty(duplicates)) {
                LOG.warn("crit header shall not contain duplicates for a JAdES-BASELINE-B signature (see RFC 7515)! Found duplicates : '{}'", (Object)duplicates);
                return false;
            }
        }
        Set<String> keySet = DSSJsonUtils.extractJOSEHeaderMembersSet(jws);
        for (String key : keySet) {
            if (DSSJsonUtils.isCriticalHeaderException(key)) {
                if (!critList.contains(key)) continue;
                LOG.warn("crit header shall not contain headers listed in RFC 7515 or RFC 7518 for a JAdES-BASELINE-B signature (see RFC 7515)! Found header : '{}'", (Object)key);
                return false;
            }
            if (!DSSJsonUtils.isRequiredCriticalHeader(key)) continue;
            if (crit == null) {
                LOG.warn("crit header shall be present when '{}' header is present in a signature for a JAdES-BASELINE-B signature!", (Object)key);
                return false;
            }
            if (critList.contains(key)) continue;
            LOG.warn("crit header shall contain '{}' header when present in a signature for a JAdES-BASELINE-B signature!", (Object)key);
            return false;
        }
        for (String critEntry : critList) {
            if (!(critEntry instanceof String)) {
                LOG.warn("An entry of crit header shall be an instance of String type for a JAdES-BASELINE-B signature!");
                return false;
            }
            if (!keySet.contains(critEntry)) {
                LOG.warn("crit header can contain only entries used within a signed header for a JAdES-BASELINE-B signature (see RFC 7515)! Found header : '{}'", (Object)critEntry);
                return false;
            }
            if (DSSJsonUtils.getSupportedProtectedCriticalHeaders().contains(critEntry) || "etsiU".equals(critEntry)) continue;
            LOG.warn("crit header shall not contain a header that cannot be understood and processed for a JAdES-BASELINE-B signature (see RFC 7515)! Found header : '{}'", (Object)critEntry);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean signingTimeRequirement(JWS jws) {
        Number iat = jws.getProtectedHeaderValueAsNumber("iat");
        String sigT = jws.getProtectedHeaderValueAsString("sigT");
        Date signingTime = ((JAdESSignature)this.signature).getSigningTime();
        if (iat == null && Utils.isStringEmpty(sigT)) {
            LOG.warn("Either iat header or sigT header (for signatures before 2025-07-15T00:00:00Z) shall be present for JAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (signingTime == null) {
            LOG.warn("Invalid date format extracted from {} header parameter for JAdES-BASELINE-B signature (cardinality == 1)!", (Object)(iat != null ? "iat" : "sigT"));
            return false;
        }
        if (iat != null) {
            if (!Utils.isStringNotEmpty(sigT)) return true;
            LOG.warn("Both iat and sigT headers are not allowed for JAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (signingTime.before(SIG_T_OBSOLESCENCE_DATE)) {
            LOG.debug("iat header should be present for JAdES-BASELINE-B signature produced before 2025-07-15T00:00:00Z (cardinality == 0 or 1)!");
            return true;
        }
        LOG.warn("iat header shall be present for JAdES-BASELINE-B signature produced starting at 2025-07-15T00:00:00Z (cardinality == 1)!");
        return false;
    }

    @Override
    public boolean hasBaselineTProfile() {
        if (!this.minimalTRequirement()) {
            return false;
        }
        JAdESEtsiUHeader etsiUHeader = ((JAdESSignature)this.signature).getEtsiUHeader();
        for (EtsiUComponent etsiUComponent : DSSJsonUtils.getUnsignedPropertiesWithHeaderName(etsiUHeader, "sigTst")) {
            Map<?, ?> sigTst = DSSJsonUtils.toMap(etsiUComponent.getValue(), "sigTst");
            List<?> tstTokens = DSSJsonUtils.getAsList(sigTst, "tstTokens");
            if (tstTokens.size() == 1) continue;
            LOG.warn("sigTst shall contain only one electronic timestamp for JAdES-BASELINE-T signature (requirement (c))!");
            return false;
        }
        if (!this.signatureTimestampsCreatedBeforeSignCertExpiration()) {
            LOG.warn("sigTst shall be created before expiration of the signing-certificate for JAdES-BASELINE-T signature (requirement (d))!");
            return false;
        }
        return true;
    }

    @Override
    public boolean hasBaselineLTProfile() {
        if (!this.minimalLTRequirement()) {
            return false;
        }
        JAdESEtsiUHeader etsiUHeader = ((JAdESSignature)this.signature).getEtsiUHeader();
        if (DSSJsonUtils.getUnsignedPropertiesWithHeaderName(etsiUHeader, "xRefs").size() > 0) {
            LOG.warn("xRefs header shall not be present for JAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (DSSJsonUtils.getUnsignedPropertiesWithHeaderName(etsiUHeader, "axRefs").size() > 0) {
            LOG.warn("axRefs header shall not be present for JAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (DSSJsonUtils.getUnsignedPropertiesWithHeaderName(etsiUHeader, "rRefs").size() > 0) {
            LOG.warn("rRefs header shall not be present for JAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (DSSJsonUtils.getUnsignedPropertiesWithHeaderName(etsiUHeader, "arRefs").size() > 0) {
            LOG.warn("arRefs header shall not be present for JAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (DSSJsonUtils.getUnsignedPropertiesWithHeaderName(etsiUHeader, "sigRTst").size() > 0) {
            LOG.warn("sigRTst header shall not be present for JAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (DSSJsonUtils.getUnsignedPropertiesWithHeaderName(etsiUHeader, "rfsTst").size() > 0) {
            LOG.warn("rfsTst header shall not be present for JAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        return true;
    }

    @Override
    protected boolean containsLTLevelCertificates() {
        return this.containsCertificateValues() || this.containsTstOrAnyValDataCertificates();
    }

    private boolean containsCertificateValues() {
        JAdESEtsiUHeader etsiUHeader = ((JAdESSignature)this.signature).getEtsiUHeader();
        return DSSJsonUtils.getUnsignedPropertiesWithHeaderName(etsiUHeader, "xVals").size() + DSSJsonUtils.getUnsignedPropertiesWithHeaderName(etsiUHeader, "axVals").size() != 0;
    }

    private boolean containsTstOrAnyValDataCertificates() {
        ArrayList<EtsiUComponent> validationDataHeaders = new ArrayList<EtsiUComponent>();
        JAdESEtsiUHeader etsiUHeader = ((JAdESSignature)this.signature).getEtsiUHeader();
        validationDataHeaders.addAll(DSSJsonUtils.getUnsignedPropertiesWithHeaderName(etsiUHeader, "tstVD"));
        validationDataHeaders.addAll(DSSJsonUtils.getUnsignedPropertiesWithHeaderName(etsiUHeader, "anyValData"));
        for (EtsiUComponent etsiUComponent : validationDataHeaders) {
            Map valDataMap = (Map)etsiUComponent.getValue();
            if (valDataMap.get("xVals") == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBaselineLTAProfile() {
        return this.minimalLTARequirement();
    }
}

