/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.jades.validation.AbstractJWSDocumentValidator;
import eu.europa.esig.dss.jades.validation.JWSCompactDocumentValidator;
import eu.europa.esig.dss.jades.validation.JWSSerializationDocumentValidator;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.validation.DocumentValidatorFactory;

public class JAdESDocumentValidatorFactory
implements DocumentValidatorFactory {
    @Override
    public boolean isSupported(DSSDocument document) {
        JWSCompactDocumentValidator compactValidator = new JWSCompactDocumentValidator();
        if (compactValidator.isSupported(document)) {
            return true;
        }
        JWSSerializationDocumentValidator serializationValidator = new JWSSerializationDocumentValidator();
        return serializationValidator.isSupported(document);
    }

    @Override
    public AbstractJWSDocumentValidator create(DSSDocument document) {
        JWSCompactDocumentValidator compactValidator = new JWSCompactDocumentValidator();
        if (compactValidator.isSupported(document)) {
            return new JWSCompactDocumentValidator(document);
        }
        JWSSerializationDocumentValidator serializationValidator = new JWSSerializationDocumentValidator();
        if (serializationValidator.isSupported(document)) {
            return new JWSSerializationDocumentValidator(document);
        }
        throw new IllegalArgumentException("Not supported document");
    }
}

