/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.tsl;

import eu.europa.esig.dss.model.timedependent.BaseTimeDependent;
import java.util.Date;
import java.util.Objects;

public class CertificateTrustTime
extends BaseTimeDependent {
    private final boolean trusted;

    public CertificateTrustTime(boolean trusted) {
        this.trusted = trusted;
    }

    public CertificateTrustTime(Date startDate, Date endDate) {
        super(startDate, endDate);
        this.trusted = true;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public boolean isTrustedAtTime(Date controlTime) {
        return this.isTrusted() && Objects.equals(this.getDateBefore(this.getStartDate(), controlTime), this.getStartDate()) && Objects.equals(this.getDateAfter(this.getEndDate(), controlTime), this.getEndDate());
    }

    public CertificateTrustTime getJointTrustTime(Date startDate, Date endDate) {
        return new CertificateTrustTime(this.getDateBefore(this.getStartDate(), startDate), this.getDateAfter(this.getEndDate(), endDate));
    }

    private Date getDateBefore(Date dateOne, Date dateTwo) {
        if (dateOne == null) {
            return dateOne;
        }
        if (dateTwo == null) {
            return dateTwo;
        }
        if (dateOne.before(dateTwo)) {
            return dateOne;
        }
        return dateTwo;
    }

    private Date getDateAfter(Date dateOne, Date dateTwo) {
        if (dateOne == null) {
            return dateOne;
        }
        if (dateTwo == null) {
            return dateTwo;
        }
        if (dateOne.after(dateTwo)) {
            return dateOne;
        }
        return dateTwo;
    }
}

