/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.pades.validation.PdfCmsOCSPSource;
import eu.europa.esig.dss.pades.validation.PdfObjectKey;
import eu.europa.esig.dss.pades.validation.dss.PdfDssDictOCSPSource;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bouncycastle.asn1.cms.AttributeTable;

public class PAdESOCSPSource
extends OfflineOCSPSource {
    private final PdfCmsOCSPSource cmsOCSPSource;
    private final PdfDssDictOCSPSource dssDictOCSPSource;

    public PAdESOCSPSource(PdfSignatureRevision pdfSignatureRevision, String vriDictionaryName, AttributeTable signedAttributes) {
        Objects.requireNonNull(vriDictionaryName, "vriDictionaryName cannot be null!");
        this.cmsOCSPSource = new PdfCmsOCSPSource(signedAttributes);
        this.dssDictOCSPSource = new PdfDssDictOCSPSource(pdfSignatureRevision.getCompositeDssDictionary().getOcspSource(), pdfSignatureRevision.getDssDictionary(), vriDictionaryName);
    }

    @Override
    public List<RevocationToken<OCSP>> getRevocationTokens(CertificateToken certificateToken, CertificateToken issuerToken) {
        ArrayList<RevocationToken<OCSP>> revocationTokens = new ArrayList<RevocationToken<OCSP>>();
        revocationTokens.addAll(this.cmsOCSPSource.getRevocationTokens(certificateToken, issuerToken));
        revocationTokens.addAll(this.dssDictOCSPSource.getRevocationTokens(certificateToken, issuerToken));
        return revocationTokens;
    }

    public Map<PdfObjectKey, OCSPResponseBinary> getOcspMap() {
        return this.dssDictOCSPSource.getOcspMap();
    }

    @Override
    public List<EncapsulatedRevocationTokenIdentifier<OCSP>> getDSSDictionaryBinaries() {
        return this.dssDictOCSPSource.getDSSDictionaryBinaries();
    }

    @Override
    public List<RevocationToken<OCSP>> getDSSDictionaryTokens() {
        return this.dssDictOCSPSource.getDSSDictionaryTokens();
    }

    @Override
    public List<EncapsulatedRevocationTokenIdentifier<OCSP>> getVRIDictionaryBinaries() {
        return this.dssDictOCSPSource.getVRIDictionaryBinaries();
    }

    @Override
    public List<RevocationToken<OCSP>> getVRIDictionaryTokens() {
        return this.dssDictOCSPSource.getVRIDictionaryTokens();
    }

    @Override
    public List<EncapsulatedRevocationTokenIdentifier<OCSP>> getADBERevocationValuesBinaries() {
        return this.cmsOCSPSource.getADBERevocationValuesBinaries();
    }

    @Override
    public List<RevocationToken<OCSP>> getADBERevocationValuesTokens() {
        return this.dssDictOCSPSource.getADBERevocationValuesTokens();
    }

    @Override
    public Map<EncapsulatedRevocationTokenIdentifier<OCSP>, Set<RevocationOrigin>> getAllRevocationBinariesWithOrigins() {
        HashMap<EncapsulatedRevocationTokenIdentifier<OCSP>, Set<RevocationOrigin>> result = new HashMap<EncapsulatedRevocationTokenIdentifier<OCSP>, Set<RevocationOrigin>>();
        this.populateMapWithSet(result, this.cmsOCSPSource.getAllRevocationBinariesWithOrigins());
        this.populateMapWithSet(result, this.dssDictOCSPSource.getAllRevocationBinariesWithOrigins());
        return result;
    }

    @Override
    public Map<RevocationToken<OCSP>, Set<RevocationOrigin>> getAllRevocationTokensWithOrigins() {
        HashMap<RevocationToken<OCSP>, Set<RevocationOrigin>> result = new HashMap<RevocationToken<OCSP>, Set<RevocationOrigin>>();
        this.populateMapWithSet(result, this.cmsOCSPSource.getAllRevocationTokensWithOrigins());
        this.populateMapWithSet(result, this.dssDictOCSPSource.getAllRevocationTokensWithOrigins());
        return result;
    }

    private <R> void populateMapWithSet(Map<R, Set<RevocationOrigin>> mapToPopulate, Map<R, Set<RevocationOrigin>> mapToAdd) {
        for (Map.Entry<R, Set<RevocationOrigin>> entry : mapToAdd.entrySet()) {
            Set<RevocationOrigin> revocationOrigins = mapToPopulate.get(entry.getKey());
            if (revocationOrigins == null) {
                revocationOrigins = new HashSet<RevocationOrigin>();
            }
            revocationOrigins.addAll((Collection<RevocationOrigin>)entry.getValue());
            mapToPopulate.put(entry.getKey(), revocationOrigins);
        }
    }
}

