/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.modifications;

import eu.europa.esig.dss.enumerations.PdfObjectModificationType;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfObject;
import eu.europa.esig.dss.pdf.modifications.ObjectModification;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModifications;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfObjectModificationsFilter {
    private static final Logger LOG = LoggerFactory.getLogger(PdfObjectModificationsFilter.class);

    public PdfObjectModifications filter(Collection<ObjectModification> objectModifications) {
        PdfObjectModifications pdfObjectModifications = new PdfObjectModifications();
        for (ObjectModification objectModification : objectModifications) {
            if (this.skipChange(objectModification)) continue;
            if (this.isExtensionChange(objectModification)) {
                pdfObjectModifications.addSecureChange(objectModification);
                continue;
            }
            if (this.isSignatureOrFormFillChange(objectModification)) {
                pdfObjectModifications.addFormFillInAndSignatureCreationChange(objectModification);
                continue;
            }
            if (this.isAnnotationChange(objectModification)) {
                pdfObjectModifications.addAnnotCreationChange(objectModification);
                continue;
            }
            pdfObjectModifications.addUndefinedChange(objectModification);
        }
        return pdfObjectModifications;
    }

    protected boolean skipChange(ObjectModification objectModification) {
        String lastKey = objectModification.getObjectTree().getLastKey();
        if (PdfObjectModificationType.DELETION.equals((Object)objectModification.getActionType()) && "AP".equals(lastKey)) {
            return true;
        }
        if (PdfObjectModificationType.MODIFICATION.equals((Object)objectModification.getActionType()) && "F".equals(lastKey)) {
            return true;
        }
        if (PdfObjectModificationType.MODIFICATION.equals((Object)objectModification.getActionType()) && "Type".equals(lastKey)) {
            return true;
        }
        return PdfObjectModificationType.MODIFICATION.equals((Object)objectModification.getActionType()) && "ITXT".equals(lastKey);
    }

    protected boolean isExtensionChange(ObjectModification objectModification) {
        if (this.isDSSDictionaryChange(objectModification)) {
            return true;
        }
        if (this.isDocTimeStampAdded(objectModification)) {
            return true;
        }
        if (this.isDocTimeStampEmptyFieldFill(objectModification)) {
            return true;
        }
        if (this.isDocTimeStampEmptyFieldFontCreation(objectModification)) {
            return true;
        }
        if (this.isDocumentExtension(objectModification)) {
            return true;
        }
        if (this.isVersionChange(objectModification)) {
            return true;
        }
        if (this.isExtensionsChange(objectModification)) {
            return true;
        }
        return this.isMetaDataChange(objectModification);
    }

    private boolean isDSSDictionaryChange(ObjectModification objectModification) {
        List<String> keyChain = objectModification.getObjectTree().getKeyChain();
        for (String key : keyChain) {
            if (!"DSS".equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isDocTimeStampAdded(ObjectModification objectModification) {
        PdfObject valueObject;
        PdfObject addedObject;
        String key = objectModification.getObjectTree().getLastKey();
        return this.isAnnotsKey(key) ? (addedObject = objectModification.getFinalObject()) instanceof PdfDict && (valueObject = ((PdfDict)addedObject).getObject("V")) instanceof PdfDict && this.isDocTimeStamp((PdfDict)valueObject) : this.isValueKey(key) && (addedObject = objectModification.getFinalObject()) instanceof PdfDict && this.isDocTimeStamp((PdfDict)addedObject);
    }

    private boolean isSignature(PdfDict pdfDict) {
        return this.isObjectOfType(pdfDict, "Sig");
    }

    private boolean isDocTimeStamp(PdfDict pdfDict) {
        return this.isObjectOfType(pdfDict, "DocTimeStamp");
    }

    private boolean isObjectOfType(PdfDict pdfDict, String typeValue) {
        PdfObject typeObject;
        return pdfDict != null && (typeObject = pdfDict.getObject("Type")) != null && typeValue.equals(typeObject.getValue());
    }

    private boolean isDocumentExtension(ObjectModification objectModification) {
        String key = objectModification.getObjectTree().getLastKey();
        String parentKey = this.getParentKey(objectModification);
        return "Extensions".equals(key) && "Catalog".equals(parentKey);
    }

    protected boolean isSignatureOrFormFillChange(ObjectModification objectModification) {
        if (this.isFieldFilled(objectModification)) {
            return true;
        }
        if (this.isAnnotsArrayCreation(objectModification)) {
            return true;
        }
        if (this.isEmptyAnnotFill(objectModification)) {
            return true;
        }
        if (this.isAnnotsFill(objectModification)) {
            return true;
        }
        if (this.isFieldAppearanceCreationChange(objectModification)) {
            return true;
        }
        if (this.isFieldValueAssignmentChange(objectModification)) {
            return true;
        }
        if (this.isSignatureEmptyFieldFill(objectModification)) {
            return true;
        }
        if (this.isCatalogPieceInfoChange(objectModification)) {
            return true;
        }
        if (this.isCatalogPermsCreationChange(objectModification)) {
            return true;
        }
        if (this.isCatalogNamesChange(objectModification)) {
            return true;
        }
        if (this.isCatalogOutputIntentsChange(objectModification)) {
            return true;
        }
        if (this.isAcroFormDictionaryChange(objectModification)) {
            return true;
        }
        return this.isSignatureEmptyFieldFontCreation(objectModification);
    }

    private boolean isFieldFilled(ObjectModification objectModification) {
        String key = objectModification.getObjectTree().getLastKey();
        if ("V".equals(key) && this.isAnnotChange(objectModification)) {
            return true;
        }
        if (this.isAnnotChange(objectModification)) {
            PdfObject addedObject = objectModification.getFinalObject();
            return addedObject instanceof PdfDict && this.isValueChange((PdfDict)addedObject);
        }
        return false;
    }

    private boolean isValueChange(PdfDict pdfDict) {
        return pdfDict.getAsDict("V") != null;
    }

    private boolean isValueKey(String key) {
        return this.isOneOf(key, "V");
    }

    private boolean isAnnotChange(ObjectModification objectModification) {
        String lastKey = objectModification.getObjectTree().getLastKey();
        String parentKey = this.getParentKey(objectModification);
        if (this.isAnnotsKey(lastKey) || this.isAnnotsKey(parentKey)) {
            return true;
        }
        boolean isAnnotProcessing = false;
        boolean resetChain = false;
        for (String key : objectModification.getObjectTree().getKeyChain()) {
            if (resetChain) {
                isAnnotProcessing = false;
                resetChain = false;
            }
            if (this.isAnnotsKey(key)) {
                isAnnotProcessing = true;
                continue;
            }
            if (this.isParentOrKid(key)) continue;
            resetChain = true;
        }
        return isAnnotProcessing && (this.isParentOrKid(lastKey) || this.isParentOrKid(parentKey));
    }

    private boolean isAnnotsKey(String key) {
        return this.isOneOf(key, "Annots", "Fields");
    }

    private boolean isParentOrKid(String key) {
        return this.isOneOf(key, "Parent", "Kids");
    }

    private boolean isAnnotsFill(ObjectModification objectModification) {
        if (!PdfObjectModificationType.DELETION.equals((Object)objectModification.getActionType())) {
            String lastKey = objectModification.getObjectTree().getLastKey();
            return this.isAnnotChange(objectModification) && !this.isAnnotsKey(lastKey);
        }
        return false;
    }

    private boolean isAnnotsArrayCreation(ObjectModification objectModification) {
        String lastKey = objectModification.getObjectTree().getLastKey();
        return PdfObjectModificationType.CREATION.equals((Object)objectModification.getActionType()) && this.isAnnotsKey(lastKey) && objectModification.getFinalObject() instanceof PdfArray;
    }

    private boolean isFieldAppearanceCreationChange(ObjectModification objectModification) {
        boolean appearanceDictChangeFound = false;
        boolean annotChangeFound = false;
        if (PdfObjectModificationType.CREATION.equals((Object)objectModification.getActionType())) {
            for (String chainKey : objectModification.getObjectTree().getKeyChain()) {
                if (this.isAnnotsKey(chainKey)) {
                    annotChangeFound = true;
                    continue;
                }
                if (!"AP".equals(chainKey)) continue;
                appearanceDictChangeFound = true;
                break;
            }
        }
        return appearanceDictChangeFound && annotChangeFound;
    }

    private boolean isFieldValueAssignmentChange(ObjectModification objectModification) {
        boolean appearanceDictChangeFound = false;
        boolean annotChangeFound = false;
        if (PdfObjectModificationType.CREATION.equals((Object)objectModification.getActionType())) {
            for (String chainKey : objectModification.getObjectTree().getKeyChain()) {
                if (this.isAnnotsKey(chainKey)) {
                    annotChangeFound = true;
                    continue;
                }
                if (!"V".equals(chainKey)) continue;
                appearanceDictChangeFound = true;
                break;
            }
        }
        return appearanceDictChangeFound && annotChangeFound;
    }

    private boolean isSignatureEmptyFieldFill(ObjectModification objectModification) {
        return this.isEmptyFieldFill(objectModification, "Sig");
    }

    private boolean isDocTimeStampEmptyFieldFill(ObjectModification objectModification) {
        return this.isEmptyFieldFill(objectModification, "DocTimeStamp");
    }

    private boolean isEmptyFieldFill(ObjectModification objectModification, String signatureType) {
        return this.isEmptyAnnotFill(objectModification) && this.checkRecursivelyForNewSignatureCreation(objectModification, signatureType);
    }

    private boolean isEmptyAnnotFill(ObjectModification objectModification) {
        boolean appearanceDictChangeFound = false;
        boolean normalAppearanceFound = false;
        if (PdfObjectModificationType.MODIFICATION.equals((Object)objectModification.getActionType())) {
            for (String chainKey : objectModification.getObjectTree().getKeyChain()) {
                if ("AP".equals(chainKey)) {
                    appearanceDictChangeFound = true;
                } else if (appearanceDictChangeFound && "N".equals(chainKey)) {
                    normalAppearanceFound = true;
                }
                if (!normalAppearanceFound) continue;
                if ("Length".equals(chainKey)) {
                    return true;
                }
                if (!this.isStreamFill(objectModification)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkRecursivelyForNewSignatureCreation(ObjectModification objectModification, String targetType) {
        return this.checkRecursivelyForNewSignatureCreation(objectModification.getOriginalObject(), objectModification.getFinalObject(), targetType);
    }

    private boolean checkRecursivelyForNewSignatureCreation(PdfObject originalObject, PdfObject finalObject, String targetType) {
        PdfObject finalParent;
        PdfObject finalSigValue;
        PdfObject originalSigValue = originalObject instanceof PdfDict ? ((PdfDict)originalObject).getObject("V") : null;
        PdfObject pdfObject = finalSigValue = finalObject instanceof PdfDict ? ((PdfDict)finalObject).getObject("V") : null;
        if (originalSigValue == null && finalSigValue instanceof PdfDict && this.isObjectOfType((PdfDict)finalSigValue, targetType)) {
            return true;
        }
        PdfObject originalParent = originalObject != null ? originalObject.getParent() : null;
        PdfObject pdfObject2 = finalParent = finalObject != null ? finalObject.getParent() : null;
        if (originalParent == null && finalParent == null) {
            return false;
        }
        return this.checkRecursivelyForNewSignatureCreation(originalParent, finalParent, targetType);
    }

    private boolean isStreamFill(ObjectModification objectModification) {
        try {
            PdfDict finalDict;
            byte[] finalBytes;
            PdfObject originalObject = objectModification.getOriginalObject();
            PdfObject finalObject = objectModification.getFinalObject();
            if (originalObject instanceof PdfDict && finalObject instanceof PdfDict && (finalBytes = (finalDict = (PdfDict)finalObject).getStreamBytes()) != null && finalBytes.length != 0) {
                return true;
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to evaluate stream modification from path '{}'. Reason : {}", objectModification.getObjectTree(), e.getMessage(), e);
        }
        return false;
    }

    private boolean isVersionChange(ObjectModification objectModification) {
        String key = objectModification.getObjectTree().getLastKey();
        String parentKey = this.getParentKey(objectModification);
        return PdfObjectModificationType.MODIFICATION.equals((Object)objectModification.getActionType()) && "Version".equals(key) && this.isOneOf(parentKey, "Catalog", "Data", "Root");
    }

    private boolean isExtensionsChange(ObjectModification objectModification) {
        List<String> keyChain = objectModification.getObjectTree().getKeyChain();
        for (String key : keyChain) {
            if (!"Extensions".equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isCatalogPieceInfoChange(ObjectModification objectModification) {
        List<String> keyChain = objectModification.getObjectTree().getKeyChain();
        for (String key : keyChain) {
            if (!"PieceInfo".equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isCatalogPermsCreationChange(ObjectModification objectModification) {
        String key = objectModification.getObjectTree().getLastKey();
        return PdfObjectModificationType.CREATION.equals((Object)objectModification.getActionType()) && "Perms".equals(key);
    }

    private boolean isCatalogNamesChange(ObjectModification objectModification) {
        List<String> keyChain = objectModification.getObjectTree().getKeyChain();
        for (String key : keyChain) {
            if (!"Names".equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isCatalogOutputIntentsChange(ObjectModification objectModification) {
        String key = objectModification.getObjectTree().getLastKey();
        return PdfObjectModificationType.CREATION.equals((Object)objectModification.getActionType()) && "OutputIntents".equals(key);
    }

    private boolean isMetaDataChange(ObjectModification objectModification) {
        String key = objectModification.getObjectTree().getLastKey();
        String parentKey = this.getParentKey(objectModification);
        return "Metadata".equals(key) || "Metadata".equals(parentKey);
    }

    private boolean isAcroFormDictionaryChange(ObjectModification objectModification) {
        boolean containsAcroForm = false;
        boolean containsResourseDict = false;
        List<String> keyChain = objectModification.getObjectTree().getKeyChain();
        for (String key : keyChain) {
            if ("AcroForm".equals(key)) {
                containsAcroForm = true;
                continue;
            }
            if (!this.isOneOf(key, "DA", "DR", "SigFlags")) continue;
            containsResourseDict = true;
        }
        return containsAcroForm && containsResourseDict;
    }

    private boolean isSignatureEmptyFieldFontCreation(ObjectModification objectModification) {
        return this.isFontCreationChange(objectModification, "Sig");
    }

    private boolean isDocTimeStampEmptyFieldFontCreation(ObjectModification objectModification) {
        return this.isFontCreationChange(objectModification, "DocTimeStamp");
    }

    private boolean isFontCreationChange(ObjectModification objectModification, String signatureType) {
        String key = objectModification.getObjectTree().getLastKey();
        String parentKey = this.getParentKey(objectModification);
        return PdfObjectModificationType.CREATION.equals((Object)objectModification.getActionType()) && ("Font".equals(key) || "Font".equals(parentKey)) && this.checkRecursivelyForNewSignatureCreation(objectModification, signatureType);
    }

    private String getParentKey(ObjectModification objectModification) {
        List<String> keyChain = objectModification.getObjectTree().getKeyChain();
        if (keyChain.size() > 1) {
            return keyChain.get(keyChain.size() - 2);
        }
        return null;
    }

    protected boolean isAnnotationChange(ObjectModification objectModification) {
        return this.isOtherAnnotChange(objectModification);
    }

    private boolean isOtherAnnotChange(ObjectModification objectModification) {
        if (this.isAnnotChange(objectModification)) {
            PdfDict pdfDict;
            PdfObject valueObject;
            if (PdfObjectModificationType.DELETION.equals((Object)objectModification.getActionType()) && objectModification.getOriginalObject() instanceof PdfDict && (valueObject = (pdfDict = (PdfDict)objectModification.getOriginalObject()).getObject("V")) instanceof PdfDict) {
                PdfDict valueDict = (PdfDict)valueObject;
                return !this.isSignature(valueDict) && !this.isDocTimeStamp(valueDict);
            }
            return true;
        }
        return false;
    }

    private boolean isOneOf(String key, String ... toCompare) {
        return Arrays.asList(toCompare).contains(key);
    }
}

