/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.policy;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.model.policy.ValidationPolicyFactory;
import eu.europa.esig.dss.policy.ValidationPolicyFacade;
import eu.europa.esig.dss.policy.jaxb.ConstraintsParameters;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class EtsiValidationPolicyFactory
implements ValidationPolicyFactory {
    private static final String DEFAULT_VALIDATION_POLICY_LOCATION = "/policy/constraint.xml";

    @Override
    public boolean isSupported(DSSDocument validationPolicyDocument) {
        boolean bl;
        block8: {
            InputStream is = validationPolicyDocument.openStream();
            try {
                ConstraintsParameters constraintsParameters = (ConstraintsParameters)ValidationPolicyFacade.newFacade().unmarshall(is, false);
                boolean bl2 = bl = constraintsParameters != null;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JAXBException | IOException | XMLStreamException | SAXException e) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    @Override
    public ValidationPolicy loadDefaultValidationPolicy() {
        try {
            return this.loadValidationPolicy(EtsiValidationPolicyFactory.class.getResourceAsStream(DEFAULT_VALIDATION_POLICY_LOCATION));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.format("Unable to load the default policy document. Reason : %s", e.getMessage()), e);
        }
    }

    @Override
    public ValidationPolicy loadValidationPolicy(DSSDocument validationPolicyDocument) {
        return this.loadValidationPolicy(validationPolicyDocument.openStream());
    }

    @Override
    public ValidationPolicy loadValidationPolicy(InputStream validationPolicyInputStream) {
        ValidationPolicy validationPolicy;
        block8: {
            InputStream is = validationPolicyInputStream;
            try {
                validationPolicy = ValidationPolicyFacade.newFacade().getValidationPolicy(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException(String.format("Unable to load the default policy document. Reason : %s", e.getMessage()), e);
                }
            }
            is.close();
        }
        return validationPolicy;
    }
}

