/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.policy.crypto.json;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.CryptographicSuiteFactory;
import eu.europa.esig.dss.policy.crypto.json.CryptographicSuiteJsonUtils;
import eu.europa.esig.dss.policy.crypto.json.CryptographicSuiteJsonWrapper;
import eu.europa.esig.json.JSONParser;
import eu.europa.esig.json.JsonObjectWrapper;
import java.io.InputStream;
import java.util.List;

public class CryptographicSuiteJsonFactory
implements CryptographicSuiteFactory {
    private static final String DEFAULT_CRYPTOGRAPHIC_SUITES_LOCATION = "/suite/dss-crypto-suite.json";

    @Override
    public boolean isSupported(DSSDocument cryptographicSuiteDocument) {
        boolean bl;
        block8: {
            InputStream is = cryptographicSuiteDocument.openStream();
            try {
                List<String> errors = CryptographicSuiteJsonUtils.getInstance().validateAgainstSchema(is);
                boolean bl2 = bl = errors == null || errors.isEmpty();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    @Override
    public CryptographicSuite loadDefaultCryptographicSuite() {
        return this.loadCryptographicSuite(CryptographicSuiteJsonFactory.class.getResourceAsStream(DEFAULT_CRYPTOGRAPHIC_SUITES_LOCATION));
    }

    @Override
    public CryptographicSuite loadCryptographicSuite(DSSDocument cryptographicSuiteDocument) {
        return this.loadCryptographicSuite(cryptographicSuiteDocument.openStream());
    }

    @Override
    public CryptographicSuite loadCryptographicSuite(InputStream cryptographicSuiteInputStream) {
        CryptographicSuiteJsonWrapper cryptographicSuiteJsonWrapper;
        block10: {
            InputStream is = cryptographicSuiteInputStream;
            try {
                JsonObjectWrapper jsonObject = new JSONParser().parse(is);
                if (jsonObject == null) {
                    throw new IllegalStateException("Parsed JSON cannot be null!");
                }
                JsonObjectWrapper securitySuitabilityPolicyType = jsonObject.getAsObject("SecuritySuitabilityPolicy");
                if (securitySuitabilityPolicyType == null) {
                    throw new IllegalArgumentException(String.format("The root element of JSON shall be a JSON object of '%s' type!", "SecuritySuitabilityPolicy"));
                }
                cryptographicSuiteJsonWrapper = new CryptographicSuiteJsonWrapper(securitySuitabilityPolicyType);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException(String.format("Unable to load the default policy document. Reason : %s", e.getMessage()), e);
                }
            }
            is.close();
        }
        return cryptographicSuiteJsonWrapper;
    }
}

