/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.policy.crypto.xml;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.policy.Abstract19322CryptographicSuite;
import eu.europa.esig.dss.model.policy.EncryptionAlgorithmWithMinKeySize;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.AlgorithmIdentifierType;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.AlgorithmType;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.EvaluationType;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.ParameterType;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.PolicyNameType;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.SecuritySuitabilityPolicyType;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.ValidityType;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptographicSuiteXmlWrapper
extends Abstract19322CryptographicSuite {
    private static final Logger LOG = LoggerFactory.getLogger(CryptographicSuiteXmlWrapper.class);
    private final SecuritySuitabilityPolicyType securitySuitabilityPolicy;

    public CryptographicSuiteXmlWrapper(SecuritySuitabilityPolicyType securitySuitabilityPolicy) {
        Objects.requireNonNull(securitySuitabilityPolicy, "securitySuitabilityPolicy cannot be null!");
        this.securitySuitabilityPolicy = securitySuitabilityPolicy;
    }

    @Override
    public String getPolicyName() {
        PolicyNameType policyName = this.securitySuitabilityPolicy.getPolicyName();
        if (policyName != null) {
            return policyName.getName();
        }
        return null;
    }

    @Override
    protected Map<DigestAlgorithm, Date> buildAcceptableDigestAlgorithmsWithExpirationDates() {
        LinkedHashMap<DigestAlgorithm, Date> digestAlgorithmsMap = new LinkedHashMap<DigestAlgorithm, Date>();
        for (AlgorithmType algorithmType : this.securitySuitabilityPolicy.getAlgorithm()) {
            Date currentEndDate;
            AlgorithmIdentifierType algorithmIdentifier = algorithmType.getAlgorithmIdentifier();
            DigestAlgorithm digestAlgorithm = this.getDigestAlgorithm(algorithmIdentifier);
            if (digestAlgorithm == null) continue;
            Date endDate = this.getDigestAlgorithmEndDate(algorithmType.getEvaluation());
            if (digestAlgorithmsMap.containsKey(digestAlgorithm) && ((currentEndDate = (Date)digestAlgorithmsMap.get(digestAlgorithm)) == null || endDate != null && currentEndDate.after(endDate))) {
                endDate = currentEndDate;
            }
            digestAlgorithmsMap.put(digestAlgorithm, endDate);
        }
        return digestAlgorithmsMap;
    }

    private DigestAlgorithm getDigestAlgorithm(AlgorithmIdentifierType algorithmIdentifier) {
        List<String> uris;
        if (algorithmIdentifier == null) {
            return null;
        }
        List<String> objectIdentifiers = algorithmIdentifier.getObjectIdentifier();
        if (objectIdentifiers != null && !objectIdentifiers.isEmpty()) {
            for (String oid : objectIdentifiers) {
                try {
                    return DigestAlgorithm.forOID(oid);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        if ((uris = algorithmIdentifier.getURI()) != null && !uris.isEmpty()) {
            for (String uri : uris) {
                try {
                    return DigestAlgorithm.forXML(uri);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return null;
    }

    private Date getDigestAlgorithmEndDate(List<EvaluationType> evaluations) {
        if (evaluations == null || evaluations.isEmpty()) {
            return null;
        }
        Date latestEndDate = null;
        for (EvaluationType evaluation : evaluations) {
            ValidityType validity = evaluation.getValidity();
            if (validity == null) continue;
            Date endDate = this.getValidityEndDate(validity);
            if (endDate == null) {
                return null;
            }
            if (latestEndDate != null && !latestEndDate.before(endDate)) continue;
            latestEndDate = endDate;
        }
        return latestEndDate;
    }

    private Date getValidityEndDate(ValidityType validity) {
        if (validity.getStart() != null) {
            LOG.debug("The Start date is not supported. The values has been skipped.");
        }
        if (validity.getEnd() != null) {
            XMLGregorianCalendar end = validity.getEnd();
            return end.toGregorianCalendar().getTime();
        }
        return null;
    }

    @Override
    protected Map<EncryptionAlgorithmWithMinKeySize, Date> buildAcceptableEncryptionAlgorithmsWithExpirationDates() {
        EncryptionAlgorithm encryptionAlgorithm;
        LinkedHashMap encryptionAlgorithmWithKeySizesMap = new LinkedHashMap();
        for (AlgorithmType algorithmType : this.securitySuitabilityPolicy.getAlgorithm()) {
            AlgorithmIdentifierType algorithmIdentifier = algorithmType.getAlgorithmIdentifier();
            encryptionAlgorithm = this.getEncryptionAlgorithm(algorithmIdentifier);
            if (encryptionAlgorithm == null) continue;
            TreeMap<Integer, Date> keySizeMap = encryptionAlgorithmWithKeySizesMap.getOrDefault(encryptionAlgorithm, new TreeMap());
            Map<Integer, Date> endDatesMap = this.getEncryptionAlgorithmKeySizeEndDates(encryptionAlgorithm, algorithmType.getEvaluation());
            for (Map.Entry<Integer, Date> entry : endDatesMap.entrySet()) {
                Date currentEndDate;
                Map.Entry higherEntry;
                Date currentEndDate2;
                Integer keySize = entry.getKey();
                Date keySizeEndDate = entry.getValue();
                Map.Entry floorEntry = keySizeMap.floorEntry(keySize);
                if (floorEntry != null && ((currentEndDate2 = (Date)floorEntry.getValue()) == null || keySizeEndDate != null && currentEndDate2.after(keySizeEndDate))) {
                    keySizeEndDate = currentEndDate2;
                }
                if ((higherEntry = keySizeMap.higherEntry(keySize)) != null && (currentEndDate = (Date)higherEntry.getValue()) != null && (keySizeEndDate == null || currentEndDate.before(keySizeEndDate))) {
                    keySizeMap.put(higherEntry.getKey(), keySizeEndDate);
                }
                keySizeMap.put(keySize, keySizeEndDate);
            }
            encryptionAlgorithmWithKeySizesMap.put(encryptionAlgorithm, keySizeMap);
        }
        LinkedHashMap<EncryptionAlgorithmWithMinKeySize, Date> encryptionAlgorithmsMap = new LinkedHashMap<EncryptionAlgorithmWithMinKeySize, Date>();
        for (Map.Entry entry : encryptionAlgorithmWithKeySizesMap.entrySet()) {
            encryptionAlgorithm = (EncryptionAlgorithm)entry.getKey();
            for (Map.Entry keySizeEntry : ((TreeMap)entry.getValue()).entrySet()) {
                encryptionAlgorithmsMap.put(new EncryptionAlgorithmWithMinKeySize(encryptionAlgorithm, (Integer)keySizeEntry.getKey()), (Date)keySizeEntry.getValue());
            }
        }
        return encryptionAlgorithmsMap;
    }

    private EncryptionAlgorithm getEncryptionAlgorithm(AlgorithmIdentifierType algorithmIdentifier) {
        List<String> uris;
        if (algorithmIdentifier == null) {
            return null;
        }
        List<String> objectIdentifiers = algorithmIdentifier.getObjectIdentifier();
        if (objectIdentifiers != null && !objectIdentifiers.isEmpty()) {
            for (String oid : objectIdentifiers) {
                try {
                    return EncryptionAlgorithm.forOID(oid);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forOID(oid);
                        return signatureAlgorithm.getEncryptionAlgorithm();
                    }
                    catch (IllegalArgumentException signatureAlgorithm) {
                    }
                }
            }
        }
        if ((uris = algorithmIdentifier.getURI()) != null && !uris.isEmpty()) {
            for (String uri : uris) {
                try {
                    SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forXML(uri);
                    return signatureAlgorithm.getEncryptionAlgorithm();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return null;
    }

    private Map<Integer, Date> getEncryptionAlgorithmKeySizeEndDates(EncryptionAlgorithm encryptionAlgorithm, List<EvaluationType> evaluations) {
        if (evaluations == null || evaluations.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Integer, Date> keySizeEndDates = new LinkedHashMap<Integer, Date>();
        for (EvaluationType evaluation : evaluations) {
            Integer keySize = this.getKeySize(encryptionAlgorithm, evaluation.getParameter());
            ValidityType validity = evaluation.getValidity();
            if (validity == null) continue;
            Date endDate = this.getValidityEndDate(validity);
            keySizeEndDates.put(keySize, endDate);
        }
        return keySizeEndDates;
    }

    private Integer getKeySize(EncryptionAlgorithm encryptionAlgorithm, List<ParameterType> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return 0;
        }
        Integer keySize = 0;
        for (ParameterType parameter : parameters) {
            String name;
            if (parameter.getMax() != null) {
                LOG.debug("The Max key length parameter is not supported. The value has been skipped.");
            }
            if ("moduluslength".equals(name = parameter.getName())) {
                if (EncryptionAlgorithm.RSA.isEquivalent(encryptionAlgorithm)) {
                    return parameter.getMin();
                }
            } else if ("plength".equals(name)) {
                if (EncryptionAlgorithm.DSA.isEquivalent(encryptionAlgorithm) || EncryptionAlgorithm.ECDSA.isEquivalent(encryptionAlgorithm) || EncryptionAlgorithm.EDDSA.isEquivalent(encryptionAlgorithm)) {
                    return parameter.getMin();
                }
            } else if (!"qlength".equals(name)) {
                LOG.warn("Unknown Algorithms Parameter type '{}'!", (Object)name);
            }
            keySize = parameter.getMin();
        }
        return keySize;
    }

    @Override
    public Date getCryptographicSuiteUpdateDate() {
        XMLGregorianCalendar policyIssueDate = this.securitySuitabilityPolicy.getPolicyIssueDate();
        if (policyIssueDate != null) {
            return policyIssueDate.toGregorianCalendar().getTime();
        }
        return null;
    }
}

