/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.esf.CrlListID;
import org.bouncycastle.asn1.esf.CrlOcspRef;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CMSCRLSource
extends OfflineCRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(CMSCRLSource.class);
    private final transient Store<X509CRLHolder> crls;
    private final transient AttributeTable unsignedAttributes;

    @Deprecated
    protected CMSCRLSource(CMSSignedData cmsSignedData, AttributeTable unsignedAttributes) {
        this(cmsSignedData.getCRLs(), unsignedAttributes);
    }

    protected CMSCRLSource(Store<X509CRLHolder> crls, AttributeTable unsignedAttributes) {
        this.crls = crls;
        this.unsignedAttributes = unsignedAttributes;
        this.extract();
    }

    private void extract() {
        this.collectFromSignedData();
        if (this.unsignedAttributes != null) {
            this.collectRevocationValues(this.unsignedAttributes, PKCSObjectIdentifiers.id_aa_ets_revocationValues, RevocationOrigin.REVOCATION_VALUES);
            this.collectRevocationRefs(PKCSObjectIdentifiers.id_aa_ets_revocationRefs, RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
            this.collectRevocationRefs(OID.attributeRevocationRefsOid, RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
        }
    }

    private void collectFromSignedData() {
        Collection<X509CRLHolder> collection = this.crls.getMatches(null);
        for (X509CRLHolder x509CRLHolder : collection) {
            this.addX509CRLHolder(x509CRLHolder, RevocationOrigin.CMS_SIGNED_DATA);
        }
    }

    private void collectRevocationValues(AttributeTable attributeTable, ASN1ObjectIdentifier revocationValuesAttribute, RevocationOrigin origin) {
        Attribute[] attributes;
        for (Attribute attribute : attributes = DSSASN1Utils.getAsn1Attributes(attributeTable, revocationValuesAttribute)) {
            Object[] attributeValues = attribute.getAttributeValues();
            if (!Utils.isArrayNotEmpty(attributeValues)) continue;
            for (Object attrValue : attributeValues) {
                this.extractRevocationValues((ASN1Encodable)attrValue, origin);
            }
        }
    }

    private void extractRevocationValues(ASN1Encodable attrValue, RevocationOrigin origin) {
        RevocationValues revValues = DSSASN1Utils.getRevocationValues(attrValue);
        if (revValues != null) {
            for (CertificateList revValue : revValues.getCrlVals()) {
                try {
                    this.addX509CRLHolder(new X509CRLHolder(revValue), origin);
                }
                catch (Exception e) {
                    String errorMessage = "Unable to process CRL binary : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                        continue;
                    }
                    LOG.warn(errorMessage, (Object)e.getMessage());
                }
            }
        }
    }

    protected void addX509CRLHolder(X509CRLHolder crlHolder, RevocationOrigin origin) {
        try {
            this.addBinary(CRLUtils.buildCRLBinary(crlHolder.getEncoded()), origin);
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to parse CRL binaries from origin '%s'. Reason : %s", new Object[]{origin, e.getMessage()}), e);
        }
    }

    private void collectRevocationRefs(ASN1ObjectIdentifier revocationRefsAttribute, RevocationRefOrigin origin) {
        try {
            Attribute[] attributes;
            for (Attribute attribute : attributes = DSSASN1Utils.getAsn1Attributes(this.unsignedAttributes, revocationRefsAttribute)) {
                Object[] attributeValues = attribute.getAttributeValues();
                if (!Utils.isArrayNotEmpty(attributeValues)) continue;
                for (Object attrValue : attributeValues) {
                    ASN1Sequence revocationRefs = (ASN1Sequence)attrValue;
                    for (int ii = 0; ii < revocationRefs.size(); ++ii) {
                        this.collectRevocationRefFromASN1Encodable(revocationRefs.getObjectAt(ii), origin);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred during extraction of revocation references from  signature unsigned properties. Revocations for origin {} were not stored", (Object)origin.toString(), (Object)e);
        }
    }

    private void collectRevocationRefFromASN1Encodable(ASN1Encodable asn1Encodable, RevocationRefOrigin origin) {
        try {
            CrlOcspRef crlOcspRef = CrlOcspRef.getInstance(asn1Encodable);
            CrlListID crlIds = crlOcspRef.getCrlids();
            if (crlIds != null) {
                for (CrlValidatedID id : crlIds.getCrls()) {
                    CRLRef crlRef = new CRLRef(id);
                    this.addRevocationReference(crlRef, origin);
                }
            }
        }
        catch (Exception e) {
            String errorMessage = "Unable to process CRL reference : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
            }
            LOG.warn(errorMessage, (Object)e.getMessage());
        }
    }
}

