/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.task.report;

import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.standalone.task.report.GenerateReportTask;
import eu.europa.esig.validationreport.ValidationReportFacade;
import eu.europa.esig.validationreport.jaxb.ValidationReportType;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateETSIValidationReportTask
extends GenerateReportTask {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateETSIValidationReportTask.class);
    private final ValidationReportType validationReport;

    public GenerateETSIValidationReportTask(ValidationReportType validationReport) {
        Objects.requireNonNull(validationReport, "Validation report cannot be null!");
        this.validationReport = validationReport;
    }

    @Override
    protected DSSDocument call() {
        LOG.debug("Generating ETSI Validation report...");
        try {
            String marshalled = ValidationReportFacade.newFacade().marshall(this.validationReport);
            return new InMemoryDocument(marshalled.getBytes(StandardCharsets.UTF_8), "Validation report.xml", (MimeType)MimeTypeEnum.XML);
        }
        catch (Exception e) {
            this.throwException("Unable to generate ETSI Validation report", e);
            return null;
        }
    }
}

