/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.token.DSSPrivateKeyAccessEntry;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import eu.europa.esig.dss.token.digest.DigestInfoEncoder;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignatureTokenConnection
implements SignatureTokenConnection {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSignatureTokenConnection.class);

    protected AbstractSignatureTokenConnection() {
    }

    @Override
    public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, DSSPrivateKeyEntry keyEntry) throws DSSException {
        EncryptionAlgorithm encryptionAlgorithm = keyEntry.getEncryptionAlgorithm();
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm(encryptionAlgorithm, digestAlgorithm);
        return this.sign(toBeSigned, signatureAlgorithm, keyEntry);
    }

    @Override
    public SignatureValue sign(ToBeSigned toBeSigned, SignatureAlgorithm signatureAlgorithm, DSSPrivateKeyEntry keyEntry) throws DSSException {
        this.assertEncryptionAlgorithmValid(signatureAlgorithm, keyEntry);
        String javaSignatureAlgorithm = signatureAlgorithm.getJCEId();
        byte[] bytes = toBeSigned.getBytes();
        AlgorithmParameterSpec param = this.initParameters(signatureAlgorithm, signatureAlgorithm.getDigestAlgorithm());
        try {
            byte[] signatureValue = this.sign(bytes, javaSignatureAlgorithm, param, keyEntry);
            SignatureValue value = new SignatureValue();
            value.setAlgorithm(signatureAlgorithm);
            value.setValue(signatureValue);
            return value;
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to sign : %s", e.getMessage()), e);
        }
    }

    @Override
    public SignatureValue signDigest(Digest digest, DSSPrivateKeyEntry keyEntry) throws DSSException {
        EncryptionAlgorithm encryptionAlgorithm = keyEntry.getEncryptionAlgorithm();
        SignatureAlgorithm signatureAlgorithm = this.getRawSignatureAlgorithm(encryptionAlgorithm);
        return this.signDigest(digest, signatureAlgorithm, keyEntry);
    }

    @Override
    public SignatureValue signDigest(Digest digest, SignatureAlgorithm signatureAlgorithm, DSSPrivateKeyEntry keyEntry) throws DSSException {
        this.assertConfigurationValid(digest, signatureAlgorithm, keyEntry);
        String javaSignatureAlgorithm = this.getRawSignatureAlgorithm(signatureAlgorithm.getEncryptionAlgorithm()).getJCEId();
        digest = this.ensureDigestUniform(signatureAlgorithm, digest);
        byte[] digestedBytes = digest.getValue();
        AlgorithmParameterSpec param = this.initParameters(signatureAlgorithm, digest.getAlgorithm());
        try {
            byte[] signatureValue = this.sign(digestedBytes, javaSignatureAlgorithm, param, keyEntry);
            SignatureValue value = new SignatureValue();
            value.setAlgorithm(this.getSignatureAlgorithm(signatureAlgorithm.getEncryptionAlgorithm(), digest.getAlgorithm()));
            value.setValue(signatureValue);
            return value;
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to sign digest : %s", e.getMessage()), e);
        }
    }

    protected Digest ensureDigestUniform(SignatureAlgorithm signatureAlgorithm, Digest digest) {
        if (EncryptionAlgorithm.RSA == signatureAlgorithm.getEncryptionAlgorithm() && !DigestInfoEncoder.isEncoded(digest.getValue())) {
            byte[] encodedDigest = DigestInfoEncoder.encode(digest.getAlgorithm().getOid(), digest.getValue());
            digest = new Digest(digest.getAlgorithm(), encodedDigest);
        }
        return digest;
    }

    protected AlgorithmParameterSpec initParameters(SignatureAlgorithm signatureAlgorithm, DigestAlgorithm digestAlgorithm) {
        if (EncryptionAlgorithm.RSASSA_PSS == signatureAlgorithm.getEncryptionAlgorithm()) {
            return this.createPSSParam(digestAlgorithm);
        }
        return null;
    }

    private byte[] sign(byte[] bytes, String javaSignatureAlgorithm, AlgorithmParameterSpec param, DSSPrivateKeyEntry keyEntry) throws GeneralSecurityException {
        if (!(keyEntry instanceof DSSPrivateKeyAccessEntry)) {
            throw new IllegalArgumentException("Only DSSPrivateKeyAccessEntry are supported");
        }
        LOG.info("Signature algorithm : {}", (Object)javaSignatureAlgorithm);
        Signature signature = this.getSignatureInstance(javaSignatureAlgorithm);
        if (param != null) {
            signature.setParameter(param);
        }
        signature.initSign(((DSSPrivateKeyAccessEntry)keyEntry).getPrivateKey());
        signature.update(bytes);
        return signature.sign();
    }

    private SignatureAlgorithm getSignatureAlgorithm(EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digestAlgorithm);
        if (signatureAlgorithm == null) {
            throw new UnsupportedOperationException(String.format("The SignatureAlgorithm is not found for the given configuration [EncryptionAlgorithm: %s; DigestAlgorithm: %s]", encryptionAlgorithm, digestAlgorithm));
        }
        return signatureAlgorithm;
    }

    private SignatureAlgorithm getRawSignatureAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, null);
        if (signatureAlgorithm == null) {
            throw new UnsupportedOperationException(String.format("The SignatureAlgorithm for digest signing is not found for the given configuration [EncryptionAlgorithm: %s]", encryptionAlgorithm));
        }
        return signatureAlgorithm;
    }

    protected Signature getSignatureInstance(String javaSignatureAlgorithm) throws NoSuchAlgorithmException {
        return Signature.getInstance(javaSignatureAlgorithm);
    }

    protected AlgorithmParameterSpec createPSSParam(DigestAlgorithm digestAlgo) {
        String digestJavaName = digestAlgo.getJavaName();
        return new PSSParameterSpec(digestJavaName, "MGF1", new MGF1ParameterSpec(digestJavaName), digestAlgo.getSaltLength(), 1);
    }

    private void assertConfigurationValid(Digest digest, SignatureAlgorithm signatureAlgorithm, DSSPrivateKeyEntry keyEntry) {
        this.assertEncryptionAlgorithmValid(signatureAlgorithm, keyEntry);
        this.assertDigestAlgorithmValid(digest, signatureAlgorithm);
    }

    private void assertEncryptionAlgorithmValid(SignatureAlgorithm signatureAlgorithm, DSSPrivateKeyEntry keyEntry) {
        Objects.requireNonNull(signatureAlgorithm, "SignatureAlgorithm shall be provided.");
        Objects.requireNonNull(signatureAlgorithm.getEncryptionAlgorithm(), "EncryptionAlgorithm shall be provided within the SignatureAlgorithm.");
        Objects.requireNonNull(keyEntry, "keyEntry shall be provided.");
        if (!signatureAlgorithm.getEncryptionAlgorithm().isEquivalent(keyEntry.getEncryptionAlgorithm())) {
            throw new IllegalArgumentException(String.format("The provided SignatureAlgorithm '%s' cannot be used to sign with the token's implied EncryptionAlgorithm '%s'", signatureAlgorithm.getName(), keyEntry.getEncryptionAlgorithm().getName()));
        }
    }

    private void assertDigestAlgorithmValid(Digest digest, SignatureAlgorithm signatureAlgorithm) {
        if (signatureAlgorithm.getDigestAlgorithm() != null && signatureAlgorithm.getDigestAlgorithm() != digest.getAlgorithm()) {
            throw new IllegalArgumentException(String.format("The DigestAlgorithm '%s' provided withing a SignatureAlgorithm does not match the one used to compute the Digest : '%s'!", signatureAlgorithm.getDigestAlgorithm().getName(), digest.getAlgorithm().getName()));
        }
    }
}

