/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.dto.condition;

import eu.europa.esig.dss.model.tsl.Condition;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class CertSubjectDNAttributeCondition
implements Condition {
    private static final long serialVersionUID = 5941353274395443267L;
    private final List<String> subjectAttributeOids;

    public CertSubjectDNAttributeCondition(List<String> oids) {
        this.subjectAttributeOids = oids;
    }

    public final List<String> getAttributeOids() {
        return this.subjectAttributeOids == null ? Collections.emptyList() : Collections.unmodifiableList(this.subjectAttributeOids);
    }

    @Override
    public boolean check(CertificateToken certificateToken) {
        if (Utils.isCollectionNotEmpty(this.subjectAttributeOids)) {
            X500PrincipalHelper subject = certificateToken.getSubject();
            for (String oid : this.subjectAttributeOids) {
                String attribute = DSSASN1Utils.extractAttributeFromX500Principal(new ASN1ObjectIdentifier(oid), subject);
                if (!Utils.isStringEmpty(attribute)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("CertSubjectDNAttributeCondition: ").append(this.subjectAttributeOids).append('\n');
        return builder.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

