/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.sync;

import eu.europa.esig.dss.model.timedependent.TimeDependentValues;
import eu.europa.esig.dss.model.tsl.CertificateTrustTime;
import eu.europa.esig.dss.model.tsl.LOTLInfo;
import eu.europa.esig.dss.model.tsl.ParsingInfoRecord;
import eu.europa.esig.dss.model.tsl.PivotInfo;
import eu.europa.esig.dss.model.tsl.TLInfo;
import eu.europa.esig.dss.model.tsl.TLValidationJobSummary;
import eu.europa.esig.dss.model.tsl.TrustProperties;
import eu.europa.esig.dss.model.tsl.TrustPropertiesCertificateSource;
import eu.europa.esig.dss.model.tsl.TrustService;
import eu.europa.esig.dss.model.tsl.TrustServiceProvider;
import eu.europa.esig.dss.model.tsl.TrustServiceStatusAndInformationExtensions;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.access.SynchronizerCacheAccess;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.dss.tsl.source.TLSource;
import eu.europa.esig.dss.tsl.summary.ValidationJobSummaryBuilder;
import eu.europa.esig.dss.tsl.sync.SynchronizationStrategy;
import eu.europa.esig.dss.tsl.sync.TrustServiceProviderBuilder;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedListCertificateSourceSynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedListCertificateSourceSynchronizer.class);
    private final TLSource[] tlSources;
    private final LOTLSource[] lotlSources;
    private final SynchronizationStrategy synchronizationStrategy;
    private final TrustPropertiesCertificateSource certificateSource;
    private final SynchronizerCacheAccess cacheAccess;

    public TrustedListCertificateSourceSynchronizer(TLSource[] tlSources, LOTLSource[] lotlSources, TrustPropertiesCertificateSource certificateSource, SynchronizationStrategy synchronizationStrategy, SynchronizerCacheAccess cacheAccess) {
        this.tlSources = tlSources;
        this.lotlSources = lotlSources;
        this.synchronizationStrategy = synchronizationStrategy;
        this.certificateSource = certificateSource;
        this.cacheAccess = cacheAccess;
    }

    public void sync() {
        try {
            ValidationJobSummaryBuilder summaryBuilder = new ValidationJobSummaryBuilder(this.cacheAccess, this.tlSources, this.lotlSources);
            TLValidationJobSummary summary = summaryBuilder.build();
            if (this.isCertificateSyncNeeded(summary)) {
                this.synchronizeCertificates(summary);
            }
            this.syncCache(summary);
            summary = summaryBuilder.build();
            this.certificateSource.setSummary(summary);
        }
        catch (Exception e) {
            LOG.error("Unable to synchronize the TrustedListsCertificateSource", e);
        }
    }

    private boolean isCertificateSyncNeeded(TLValidationJobSummary summary) {
        for (LOTLInfo lotlInfo : summary.getLOTLInfos()) {
            if (!this.isTLParsingDesyncOrError(lotlInfo) && !this.isTLParsingDesyncOrError(lotlInfo.getTLInfos())) continue;
            return true;
        }
        return this.isTLParsingDesyncOrError(summary.getOtherTLInfos());
    }

    private boolean isTLParsingDesyncOrError(List<TLInfo> tlInfos) {
        return tlInfos.stream().anyMatch(this::isTLParsingDesyncOrError);
    }

    private boolean isTLParsingDesyncOrError(TLInfo tlInfo) {
        ParsingInfoRecord parsingCacheInfo = tlInfo.getParsingCacheInfo();
        return parsingCacheInfo == null || parsingCacheInfo.isDesynchronized() || parsingCacheInfo.isError();
    }

    private void synchronizeCertificates(TLValidationJobSummary summary) {
        WeakHashMap<CertificateToken, List<TrustProperties>> trustPropertiesByCerts = new WeakHashMap<CertificateToken, List<TrustProperties>>();
        WeakHashMap<CertificateToken, List<CertificateTrustTime>> trustTimeByCerts = new WeakHashMap<CertificateToken, List<CertificateTrustTime>>();
        for (LOTLInfo lotlInfo : summary.getLOTLInfos()) {
            if (this.synchronizationStrategy.canBeSynchronized(lotlInfo)) {
                this.addCertificatesFromTLs(trustPropertiesByCerts, trustTimeByCerts, lotlInfo.getTLInfos(), lotlInfo);
                continue;
            }
            LOG.warn("Certificate synchronization is skipped for LOTL '{}' and its TLs", (Object)lotlInfo.getUrl());
        }
        this.addCertificatesFromTLs(trustPropertiesByCerts, trustTimeByCerts, summary.getOtherTLInfos(), null);
        this.certificateSource.setTrustPropertiesByCertificates(trustPropertiesByCerts);
        this.certificateSource.setTrustTimeByCertificates(trustTimeByCerts);
    }

    private void addCertificatesFromTLs(Map<CertificateToken, List<TrustProperties>> trustPropertiesByCerts, Map<CertificateToken, List<CertificateTrustTime>> trustTimeByCerts, List<TLInfo> tlInfos, LOTLInfo relatedLOTL) {
        for (TLInfo tlInfo : tlInfos) {
            if (this.synchronizationStrategy.canBeSynchronized(tlInfo)) {
                ParsingInfoRecord parsingCacheInfo = tlInfo.getParsingCacheInfo();
                if (parsingCacheInfo == null || !parsingCacheInfo.isResultExist()) {
                    LOG.warn("No Parsing result for TLInfo with url [{}]", (Object)tlInfo.getUrl());
                    continue;
                }
                List<TrustServiceProvider> trustServiceProviders = parsingCacheInfo.getTrustServiceProviders();
                if (!Utils.isCollectionNotEmpty(trustServiceProviders)) continue;
                Predicate<TrustServiceStatusAndInformationExtensions> trustAnchorValidityPredicate = this.getTrustAnchorValidityPredicate(tlInfo, relatedLOTL);
                for (TrustServiceProvider original : trustServiceProviders) {
                    TrustServiceProvider detached = this.getDetached(original);
                    for (TrustService trustService : original.getServices()) {
                        TimeDependentValues<TrustServiceStatusAndInformationExtensions> statusAndInformationExtensions = trustService.getStatusAndInformationExtensions();
                        TrustProperties trustProperties = this.getTrustProperties(relatedLOTL, tlInfo, detached, statusAndInformationExtensions);
                        List<CertificateTrustTime> certificateTrustTimes = this.getCertificateTrustTimes(statusAndInformationExtensions, trustAnchorValidityPredicate);
                        for (CertificateToken certificate : trustService.getCertificates()) {
                            this.addCertificate(trustPropertiesByCerts, trustTimeByCerts, certificate, trustProperties, certificateTrustTimes);
                        }
                    }
                }
                continue;
            }
            LOG.warn("Certificate synchronization is skipped for TL '{}'", (Object)tlInfo.getUrl());
        }
    }

    private void addCertificate(Map<CertificateToken, List<TrustProperties>> trustPropertiesByCerts, Map<CertificateToken, List<CertificateTrustTime>> trustTimeByCerts, CertificateToken certificate, TrustProperties trustProperties, List<CertificateTrustTime> certificateTrustTimes) {
        List trustPropertiesList = trustPropertiesByCerts.computeIfAbsent(certificate, k -> new ArrayList());
        if (!trustPropertiesList.contains(trustProperties)) {
            trustPropertiesList.add(trustProperties);
        }
        List certificateTrustTimeList = trustTimeByCerts.computeIfAbsent(certificate, k -> new ArrayList());
        for (CertificateTrustTime certificateTrustTime : certificateTrustTimes) {
            if (certificateTrustTimeList.contains(certificateTrustTime)) continue;
            certificateTrustTimeList.add(certificateTrustTime);
        }
    }

    private TrustServiceProvider getDetached(TrustServiceProvider original) {
        TrustServiceProviderBuilder builder = new TrustServiceProviderBuilder(original);
        builder.setServices(Collections.emptyList());
        return builder.build();
    }

    private void syncCache(TLValidationJobSummary summary) {
        for (LOTLInfo lotlInfo : summary.getLOTLInfos()) {
            this.syncTLInfosCache(lotlInfo.getTLInfos());
            this.syncPivotsCache(lotlInfo.getPivotInfos());
            this.cacheAccess.sync(new CacheKey(lotlInfo.getUrl()));
        }
        this.syncTLInfosCache(summary.getOtherTLInfos());
    }

    private void syncPivotsCache(List<PivotInfo> pivotInfos) {
        for (PivotInfo pivotInfo : pivotInfos) {
            this.cacheAccess.sync(new CacheKey(pivotInfo.getUrl()));
        }
    }

    private void syncTLInfosCache(List<TLInfo> tlInfos) {
        for (TLInfo tlInfo : tlInfos) {
            this.cacheAccess.sync(new CacheKey(tlInfo.getUrl()));
        }
    }

    private TrustProperties getTrustProperties(LOTLInfo relatedLOTL, TLInfo tlInfo, TrustServiceProvider detached, TimeDependentValues<TrustServiceStatusAndInformationExtensions> statusAndInformationExtensions) {
        if (relatedLOTL == null) {
            return new TrustProperties(tlInfo, detached, statusAndInformationExtensions);
        }
        return new TrustProperties(relatedLOTL, tlInfo, detached, statusAndInformationExtensions);
    }

    private List<CertificateTrustTime> getCertificateTrustTimes(TimeDependentValues<TrustServiceStatusAndInformationExtensions> statusAndInformationExtensions, Predicate<TrustServiceStatusAndInformationExtensions> trustAnchorValidityPredicate) {
        if (trustAnchorValidityPredicate == null) {
            return Collections.singletonList(new CertificateTrustTime(true));
        }
        ArrayList<CertificateTrustTime> result = new ArrayList<CertificateTrustTime>();
        for (TrustServiceStatusAndInformationExtensions trustServiceStatusAndInformation : statusAndInformationExtensions) {
            if (trustAnchorValidityPredicate.test(trustServiceStatusAndInformation)) {
                result.add(new CertificateTrustTime(trustServiceStatusAndInformation.getStartDate(), trustServiceStatusAndInformation.getEndDate()));
                continue;
            }
            result.add(new CertificateTrustTime(false));
        }
        return result;
    }

    private Predicate<TrustServiceStatusAndInformationExtensions> getTrustAnchorValidityPredicate(TLInfo tlInfo, LOTLInfo relatedLOTLInfo) {
        TLSource tlSource = this.getRelatedTLSource(tlInfo, relatedLOTLInfo);
        if (tlSource != null) {
            return tlSource.getTrustAnchorValidityPredicate();
        }
        return null;
    }

    private TLSource getRelatedTLSource(TLInfo tlInfo, LOTLInfo relatedLOTLInfo) {
        if (relatedLOTLInfo != null) {
            for (TLSource tLSource : this.lotlSources) {
                if (!tLSource.getUrl().equals(relatedLOTLInfo.getUrl())) continue;
                return tLSource;
            }
        }
        for (TLSource tLSource : this.tlSources) {
            if (!tLSource.getUrl().equals(tlInfo.getUrl())) continue;
            return tLSource;
        }
        return null;
    }
}

