/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.model.policy.CertificateApplicabilityRule;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Collections;
import java.util.List;

public abstract class AbstractCertificateCheckItem<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final CertificateApplicabilityRule constraint;

    protected AbstractCertificateCheckItem(I18nProvider i18nProvider, T result, CertificateApplicabilityRule constraint) {
        super(i18nProvider, result, constraint);
        this.constraint = constraint;
    }

    protected AbstractCertificateCheckItem(I18nProvider i18nProvider, T result, CertificateWrapper certificate, CertificateApplicabilityRule constraint) {
        super(i18nProvider, result, constraint, certificate.getId());
        this.constraint = constraint;
    }

    protected boolean processCertificateCheck(CertificateWrapper certificate) {
        if (this.constraint == null) {
            return false;
        }
        MultiValuesRule certificateExtensionsConstraint = this.constraint.getCertificateExtensions();
        List<String> expectedCertificateExtensions = certificateExtensionsConstraint != null ? certificateExtensionsConstraint.getValues() : Collections.emptyList();
        MultiValuesRule certificatePoliciesConstraint = this.constraint.getCertificatePolicies();
        List<String> expectedCertificatePolicies = certificatePoliciesConstraint != null ? certificatePoliciesConstraint.getValues() : Collections.emptyList();
        return Utils.isCollectionNotEmpty(expectedCertificateExtensions) && Utils.isCollectionNotEmpty(certificate.getCertificateExtensionsOids()) && ValidationProcessUtils.processValuesCheck(certificate.getCertificateExtensionsOids(), expectedCertificateExtensions) || Utils.isCollectionNotEmpty(expectedCertificatePolicies) && Utils.isCollectionNotEmpty(certificate.getCertificatePoliciesOids()) && ValidationProcessUtils.processValuesCheck(certificate.getCertificatePoliciesOids(), expectedCertificatePolicies);
    }
}

