/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.AbstractSignatureWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;

public abstract class FilenameAdherenceCheck<T extends AbstractSignatureWrapper>
extends ChainItem<XmlFC> {
    protected static final String META_INF_FOLDER = "META-INF/";
    protected static final String SIGNATURE_FILENAME = "signature";
    protected static final String TIMESTAMP_FILENAME = "timestamp";
    protected static final String EVIDENCE_RECORD_FILENAME = "evidencerecord";
    protected static final String ARCHIVE_MANIFEST_FILENAME = "ASiCArchiveManifest";
    protected static final String ASICE_METAINF_MANIFEST = "META-INF/manifest.xml";
    protected static final String METAINF_ASIC_MANIFEST = "META-INF/ASiCManifest";
    protected static final String XML_EXTENSION = ".xml";
    protected final T token;
    protected final DiagnosticData diagnosticData;

    protected FilenameAdherenceCheck(I18nProvider i18nProvider, XmlFC result, DiagnosticData diagnosticData, T token, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.token = token;
        this.diagnosticData = diagnosticData;
    }

    protected boolean isASiCManifest(String filename) {
        return filename.startsWith(METAINF_ASIC_MANIFEST) && filename.endsWith(XML_EXTENSION);
    }

    protected boolean isASiCArchiveManifest(String filename) {
        return filename.startsWith(META_INF_FOLDER) && filename.contains(ARCHIVE_MANIFEST_FILENAME) && filename.endsWith(XML_EXTENSION);
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

