/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlManifestFile;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.FilenameAdherenceCheck;

public class TimestampManifestFilenameAdherenceCheck
extends FilenameAdherenceCheck<TimestampWrapper> {
    protected static final String LAST_ARCHIVE_MANIFEST_FILENAME = "META-INF/ASiCArchiveManifest.xml";

    public TimestampManifestFilenameAdherenceCheck(I18nProvider i18nProvider, XmlFC result, DiagnosticData diagnosticData, TimestampWrapper token, LevelRule constraint) {
        super(i18nProvider, result, diagnosticData, token, constraint);
    }

    @Override
    protected boolean process() {
        if (ASiCContainerType.ASiC_S == this.diagnosticData.getContainerType()) {
            return true;
        }
        XmlManifestFile manifestFile = this.diagnosticData.getManifestFileForFilename(((TimestampWrapper)this.token).getFilename());
        if (manifestFile == null) {
            return false;
        }
        String manifestFilename = manifestFile.getFilename();
        if (Utils.isStringEmpty(manifestFilename)) {
            return false;
        }
        if (this.coversArchivalContent(manifestFile)) {
            return this.isLastArchivalTimestamp() ? LAST_ARCHIVE_MANIFEST_FILENAME.equals(manifestFilename) : this.isASiCArchiveManifest(manifestFilename);
        }
        return this.isASiCManifest(manifestFilename);
    }

    private boolean coversArchivalContent(XmlManifestFile manifestFile) {
        return manifestFile.getEntries().stream().anyMatch(m -> m.startsWith("META-INF/") && (m.contains("signature") || m.contains("timestamp") || m.contains("evidencerecord")));
    }

    private boolean isLastArchivalTimestamp() {
        for (TimestampWrapper timestampWrapper : this.diagnosticData.getTimestampList()) {
            XmlManifestFile tstManifest;
            if (timestampWrapper.getFilename() == null || timestampWrapper.getFilename().equals(((TimestampWrapper)this.token).getFilename()) || !this.coversFilename(tstManifest = this.diagnosticData.getManifestFileForFilename(timestampWrapper.getFilename()), ((TimestampWrapper)this.token).getFilename())) continue;
            return false;
        }
        return true;
    }

    private boolean coversFilename(XmlManifestFile manifestFile, String filename) {
        return manifestFile != null && manifestFile.getEntries().stream().anyMatch(e -> e.equals(filename));
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_FC_IMFCS;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_FC_IMFCS_ANS;
    }
}

