/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.CryptographicChecker;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.DigestMatcherListCryptographicChainBuilder;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.SigningCertificateRefDigestAlgorithmCheckChainBuilder;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.AllCertificatesInPathReferencedCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningCertificateAttributePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningCertificateReferencesValidityCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.UnicitySigningCertificateAttributeCheck;
import java.util.Date;
import java.util.List;

public abstract class AbstractAcceptanceValidation<T extends AbstractTokenProxy>
extends Chain<XmlSAV> {
    protected final T token;
    protected final Date currentTime;
    protected final Context context;
    protected final ValidationPolicy validationPolicy;
    private XmlCryptographicValidation cryptographicValidation;

    protected AbstractAcceptanceValidation(I18nProvider i18nProvider, T token, Date currentTime, Context context, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlSAV());
        this.token = token;
        this.currentTime = currentTime;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    protected ChainItem<XmlSAV> signingCertificateAttributePresent() {
        LevelRule constraint = this.validationPolicy.getSigningCertificateAttributePresentConstraint(this.context);
        return new SigningCertificateAttributePresentCheck(this.i18nProvider, (XmlSAV)this.result, (TokenProxy)this.token, constraint);
    }

    protected ChainItem<XmlSAV> unicitySigningCertificateAttribute() {
        LevelRule constraint = this.validationPolicy.getUnicitySigningCertificateAttributeConstraint(this.context);
        return new UnicitySigningCertificateAttributeCheck(this.i18nProvider, (XmlSAV)this.result, (TokenProxy)this.token, constraint);
    }

    protected ChainItem<XmlSAV> signingCertificateReferencesValidity() {
        LevelRule constraint = this.validationPolicy.getSigningCertificateRefersCertificateChainConstraint(this.context);
        return new SigningCertificateReferencesValidityCheck(this.i18nProvider, (XmlSAV)this.result, (TokenProxy)this.token, constraint);
    }

    protected ChainItem<XmlSAV> allCertificatesInPathReferenced() {
        LevelRule constraint = this.validationPolicy.getReferencesToAllCertificateChainPresentConstraint(this.context);
        return new AllCertificatesInPathReferencedCheck(this.i18nProvider, (XmlSAV)this.result, (TokenProxy)this.token, constraint);
    }

    protected ChainItem<XmlSAV> cryptographic(ChainItem<XmlSAV> item) {
        CryptographicSuite constraint = this.validationPolicy.getSignatureCryptographicConstraint(this.context);
        MessageTag position = ValidationProcessUtils.getCryptoPosition(this.context);
        CryptographicChecker cc = new CryptographicChecker(this.i18nProvider, (TokenProxy)this.token, this.currentTime, position, constraint);
        XmlCC ccResult = (XmlCC)cc.execute();
        if (item == null) {
            this.firstItem = this.cryptographicCheckResult(ccResult, position, constraint);
            item = this.firstItem;
        } else {
            item = item.setNextItem(this.cryptographicCheckResult(ccResult, position, constraint));
        }
        this.cryptographicValidation = this.getCryptographicValidation(ccResult);
        this.cryptographicValidation.setConcernedMaterial(this.token.getId());
        if (!this.isValid(ccResult)) {
            return item;
        }
        List<XmlDigestMatcher> digestMatchers = ((AbstractTokenProxy)this.token).getDigestMatchers();
        if (Utils.isCollectionNotEmpty(digestMatchers)) {
            DigestMatcherListCryptographicChainBuilder<XmlSAV> digestMatcherCCBuilder = new DigestMatcherListCryptographicChainBuilder<XmlSAV>(this.i18nProvider, (XmlSAV)this.result, digestMatchers, this.currentTime, constraint);
            item = digestMatcherCCBuilder.build(item);
            XmlCC failedCC = digestMatcherCCBuilder.getConcernedCC();
            if (failedCC != null && !this.isValid(failedCC)) {
                this.cryptographicValidation = this.getCryptographicValidation(failedCC);
                List<String> failedMaterial = digestMatcherCCBuilder.getConcernedMaterial();
                this.cryptographicValidation.setConcernedMaterial(this.getConcernedMaterialDescription(failedMaterial, position));
            }
        }
        return item;
    }

    protected ChainItem<XmlSAV> cryptographicSignedAttributes(ChainItem<XmlSAV> item) {
        SigningCertificateRefDigestAlgorithmCheckChainBuilder<XmlSAV> chainBuilder = new SigningCertificateRefDigestAlgorithmCheckChainBuilder<XmlSAV>(this.i18nProvider, (XmlSAV)this.result, this.currentTime, (TokenProxy)this.token, this.context, this.validationPolicy);
        item = chainBuilder.build(item);
        XmlCryptographicValidation signCertRefDigestAlgoValidation = chainBuilder.getCryptographicValidation();
        if ((this.cryptographicValidation == null || this.cryptographicValidation.isSecure()) && signCertRefDigestAlgoValidation != null && !signCertRefDigestAlgoValidation.isSecure()) {
            this.cryptographicValidation = signCertRefDigestAlgoValidation;
        }
        return item;
    }

    private ChainItem<XmlSAV> cryptographicCheckResult(XmlCC ccResult, MessageTag position, CryptographicSuite constraint) {
        return new CryptographicCheckerResultCheck<XmlSAV>(this.i18nProvider, (XmlSAV)this.result, this.currentTime, position, ccResult, constraint);
    }

    @Override
    protected void addAdditionalInfo() {
        super.addAdditionalInfo();
        ((XmlSAV)this.result).setCryptographicValidation(this.cryptographicValidation);
    }

    private XmlCryptographicValidation getCryptographicValidation(XmlCC ccResult) {
        XmlCryptographicValidation xmlCryptographicValidation = new XmlCryptographicValidation();
        xmlCryptographicValidation.setAlgorithm(ccResult.getVerifiedAlgorithm());
        xmlCryptographicValidation.setNotAfter(ccResult.getNotAfter());
        xmlCryptographicValidation.setSecure(this.isValid(ccResult));
        xmlCryptographicValidation.setValidationTime(this.currentTime);
        return xmlCryptographicValidation;
    }

    private String getConcernedMaterialDescription(List<String> referenceNames, MessageTag position) {
        if (Utils.isCollectionNotEmpty(referenceNames)) {
            return this.i18nProvider.getMessage(MessageTag.ACCM_DESC_WITH_NAME, new Object[]{position, Utils.joinStrings(referenceNames, ", ")});
        }
        return this.i18nProvider.getMessage(position, new Object[0]);
    }
}

