/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.CryptographicChecker;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheckerResultCheck;
import java.util.Date;
import java.util.List;

public class CertificateChainCryptographicChecker
extends Chain<XmlCC> {
    private final CertificateWrapper signingCertificate;
    private final List<CertificateWrapper> certificateChain;
    private final Date validationTime;
    private final Context context;
    private final MessageTag position;
    private final ValidationPolicy validationPolicy;
    private XmlCC ccResult;

    public CertificateChainCryptographicChecker(I18nProvider i18nProvider, CertificateWrapper signingCertificate, List<CertificateWrapper> certificateChain, Date validationTime, Context context, MessageTag position, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlCC());
        this.signingCertificate = signingCertificate;
        this.certificateChain = certificateChain;
        this.validationTime = validationTime;
        this.context = context;
        this.position = position;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlCC> item = null;
        for (CertificateWrapper certificate : this.certificateChain) {
            SubContext subContext;
            SubContext subContext2 = subContext = this.signingCertificate.getId().equals(certificate.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
            if (this.isTrustAnchor(certificate, subContext)) break;
            CryptographicSuite constraint = this.validationPolicy.getCertificateCryptographicConstraint(this.context, subContext);
            CryptographicChecker cc = new CryptographicChecker(this.i18nProvider, certificate, this.validationTime, this.position, constraint);
            XmlCC xmlCC = (XmlCC)cc.execute();
            ChainItem<XmlCC> certCryptoValidation = this.tokenUsedAlgorithmsAreSecureAtTime(this.validationTime, this.position, xmlCC, constraint);
            if (item == null) {
                this.firstItem = item = certCryptoValidation;
            } else {
                item = item.setNextItem(certCryptoValidation);
            }
            if (this.ccResult != null && this.isValid(xmlCC)) continue;
            this.ccResult = xmlCC;
        }
    }

    private boolean isTrustAnchor(CertificateWrapper certificateWrapper, SubContext subContext) {
        LevelRule sunsetDateConstraint = this.validationPolicy.getCertificateSunsetDateConstraint(this.context, subContext);
        return ValidationProcessUtils.isTrustAnchor(certificateWrapper, this.validationTime, sunsetDateConstraint);
    }

    private ChainItem<XmlCC> tokenUsedAlgorithmsAreSecureAtTime(Date validationDate, MessageTag position, XmlCC cc, CryptographicSuite constraint) {
        return new CryptographicCheckerResultCheck<XmlCC>(this.i18nProvider, (XmlCC)this.result, validationDate, position, cc, constraint);
    }

    @Override
    protected void addAdditionalInfo() {
        super.addAdditionalInfo();
        if (this.ccResult != null) {
            ((XmlCC)this.result).setVerifiedAlgorithm(this.ccResult.getVerifiedAlgorithm());
            ((XmlCC)this.result).setNotAfter(this.ccResult.getNotAfter());
        }
    }
}

