/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class CertificateValidityRangeCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final Date currentTime;
    private final CertificateWrapper certificate;
    private final CertificateRevocationWrapper usedCertificateRevocation;
    private final boolean revocationDataRequired;
    private final boolean revocationIssuerTrusted;
    private final boolean revocationIssuerCheckEnforced;

    public CertificateValidityRangeCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificate, CertificateRevocationWrapper usedCertificateRevocation, boolean revocationDataRequired, boolean revocationIssuerTrusted, boolean revocationIssuerCheckEnforced, Date currentTime, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.currentTime = currentTime;
        this.certificate = certificate;
        this.usedCertificateRevocation = usedCertificateRevocation;
        this.revocationDataRequired = revocationDataRequired;
        this.revocationIssuerTrusted = revocationIssuerTrusted;
        this.revocationIssuerCheckEnforced = revocationIssuerCheckEnforced;
    }

    @Override
    protected boolean process() {
        return this.isInValidityRange(this.certificate);
    }

    private boolean isInValidityRange(CertificateWrapper certificateWrapper) {
        if (certificateWrapper != null) {
            Date notBefore = certificateWrapper.getNotBefore();
            Date notAfter = certificateWrapper.getNotAfter();
            return notBefore != null && this.currentTime.compareTo(notBefore) >= 0 && notAfter != null && this.currentTime.compareTo(notAfter) <= 0;
        }
        return false;
    }

    private boolean isRevocationDataValid() {
        return this.revocationIssuerTrusted || !this.revocationIssuerCheckEnforced || this.isInValidityRange(this.usedCertificateRevocation.getSigningCertificate());
    }

    @Override
    protected String buildAdditionalInfo() {
        String notBeforeStr = this.certificate.getNotBefore() == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.certificate.getNotBefore());
        String notAfterStr = this.certificate.getNotAfter() == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.certificate.getNotAfter());
        String validationTime = ValidationProcessUtils.getFormattedDate(this.currentTime);
        return this.i18nProvider.getMessage(MessageTag.CERTIFICATE_VALIDITY, validationTime, notBeforeStr, notAfterStr);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_ICTIVRSC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_ICTIVRSC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        boolean certificateIsKnownToNotBeRevoked;
        boolean bl = certificateIsKnownToNotBeRevoked = this.usedCertificateRevocation != null && !this.usedCertificateRevocation.isRevoked() && this.isRevocationDataValid();
        if (!this.revocationDataRequired || certificateIsKnownToNotBeRevoked) {
            return SubIndication.OUT_OF_BOUNDS_NOT_REVOKED;
        }
        return SubIndication.OUT_OF_BOUNDS_NO_POE;
    }
}

