/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class RevocationIssuerValidityRangeCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final Date currentTime;
    private final RevocationWrapper revocationWrapper;

    public RevocationIssuerValidityRangeCheck(I18nProvider i18nProvider, T result, RevocationWrapper revocationWrapper, Date currentTime, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.currentTime = currentTime;
        this.revocationWrapper = revocationWrapper;
    }

    @Override
    protected boolean process() {
        CertificateWrapper signingCertificate = this.revocationWrapper.getSigningCertificate();
        if (signingCertificate != null) {
            Date notBefore = signingCertificate.getNotBefore();
            Date notAfter = signingCertificate.getNotAfter();
            return notBefore != null && this.currentTime.compareTo(notBefore) >= 0 && notAfter != null && this.currentTime.compareTo(notAfter) <= 0;
        }
        return false;
    }

    @Override
    protected String buildAdditionalInfo() {
        CertificateWrapper certificate = this.revocationWrapper.getSigningCertificate();
        if (certificate != null) {
            String notBeforeStr = certificate.getNotBefore() == null ? " ? " : ValidationProcessUtils.getFormattedDate(certificate.getNotBefore());
            String notAfterStr = certificate.getNotAfter() == null ? " ? " : ValidationProcessUtils.getFormattedDate(certificate.getNotAfter());
            String validationTime = ValidationProcessUtils.getFormattedDate(this.currentTime);
            return this.i18nProvider.getMessage(MessageTag.REVOCATION_CERT_VALIDITY, certificate.getId(), this.revocationWrapper.getId(), notBeforeStr, notAfterStr, validationTime);
        }
        return null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_ICTIVRCIRI;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_ICTIVRCIRI_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE;
    }
}

