/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import java.util.Date;

public class POEExistsCheck
extends ChainItem<XmlPSV> {
    private final TokenProxy token;
    private final Date controlTime;
    private final POEExtraction poe;

    public POEExistsCheck(I18nProvider i18nProvider, XmlPSV result, TokenProxy token, Date controlTime, POEExtraction poe, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.token = token;
        this.controlTime = controlTime;
        this.poe = poe;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.PCV;
    }

    @Override
    public boolean process() {
        return this.controlTime != null && this.poe.isPOEExists(this.token.getId(), this.controlTime);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.PSV_ITPOSVAOBCT;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PSV_ITPOSVAOBCT_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return null;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }

    @Override
    protected String buildAdditionalInfo() {
        return this.i18nProvider.getMessage(MessageTag.CONTROL_TIME_WITH_POE, ValidationProcessUtils.getFormattedDate(this.controlTime), ValidationProcessUtils.getFormattedDate(this.poe.getLowestPOETime(this.token.getId())));
    }
}

