/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.dataobject;

import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.dataobject.DSSDataObjectFormat;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DataObjectFormatBuilder {
    private Collection<DSSReference> references;

    public DataObjectFormatBuilder setReferences(Collection<DSSReference> references) {
        this.references = references;
        return this;
    }

    public List<DSSDataObjectFormat> build() {
        if (Utils.isCollectionEmpty(this.references)) {
            return Collections.emptyList();
        }
        ArrayList<DSSDataObjectFormat> result = new ArrayList<DSSDataObjectFormat>();
        for (DSSReference reference : this.references) {
            if (DSSXMLUtils.isCounterSignatureReferenceType(reference.getType())) continue;
            result.add(this.toDataObjectFormat(reference));
        }
        return result;
    }

    protected DSSDataObjectFormat toDataObjectFormat(DSSReference reference) {
        Objects.requireNonNull(reference, "Reference cannot be null!");
        DSSDataObjectFormat dataObjectFormat = new DSSDataObjectFormat();
        if (Utils.isStringNotEmpty(reference.getId())) {
            dataObjectFormat.setObjectReference(DomUtils.toElementReference(reference.getId()));
        }
        dataObjectFormat.setMimeType(this.getReferenceMimeType(reference));
        return dataObjectFormat;
    }

    private String getReferenceMimeType(DSSReference reference) {
        MimeType dataObjectFormatMimeType = MimeTypeEnum.BINARY;
        DSSDocument content = reference.getContents();
        if (content != null && content.getMimeType() != null) {
            dataObjectFormatMimeType = content.getMimeType();
        }
        return dataObjectFormatMimeType.getMimeTypeString();
    }
}

