/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.spi.DSSMessageDigestCalculator;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.ReferenceBuilder;
import eu.europa.esig.dss.xades.reference.ReferenceIdProvider;
import eu.europa.esig.dss.xades.reference.ReferenceOutputType;
import eu.europa.esig.dss.xades.reference.ReferenceProcessor;
import eu.europa.esig.dss.xades.reference.ReferenceVerifier;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.dss.xml.utils.XMLCanonicalizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.tsp.TSPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllDataObjectsTimeStampBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AllDataObjectsTimeStampBuilder.class);
    private final TSPSource tspSource;
    private final XAdESSignatureParameters signatureParameters;

    public AllDataObjectsTimeStampBuilder(TSPSource tspSource, XAdESSignatureParameters signatureParameters) {
        this.tspSource = tspSource;
        this.signatureParameters = signatureParameters;
    }

    public TimestampToken build(DSSDocument document) {
        return this.build(Arrays.asList(document));
    }

    public TimestampToken build(List<DSSDocument> documents) {
        this.assertTimestampCreationPossible(documents);
        List<DSSReference> references = this.signatureParameters.getReferences();
        if (Utils.isCollectionEmpty(references)) {
            ReferenceIdProvider referenceIdProvider = new ReferenceIdProvider();
            referenceIdProvider.setSignatureParameters(this.signatureParameters);
            ReferenceBuilder referenceBuilder = new ReferenceBuilder(documents, this.signatureParameters, referenceIdProvider);
            references = referenceBuilder.build();
            this.signatureParameters.getContext().setReferences(references);
        } else {
            ReferenceVerifier referenceVerifier = new ReferenceVerifier(this.signatureParameters);
            referenceVerifier.checkReferencesValidity();
        }
        XAdESTimestampParameters contentTimestampParameters = this.signatureParameters.getContentTimestampParameters();
        String canonicalizationMethod = contentTimestampParameters.getCanonicalizationMethod();
        DigestAlgorithm digestAlgorithm = contentTimestampParameters.getDigestAlgorithm();
        DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(digestAlgorithm);
        for (DSSReference reference : references) {
            InputStream referenceIs;
            block11: {
                ReferenceProcessor referenceProcessor = new ReferenceProcessor(this.signatureParameters);
                DSSDocument referenceContent = referenceProcessor.getReferenceOutput(reference);
                referenceIs = null;
                try {
                    if (ReferenceOutputType.NODE_SET.equals((Object)DSSXMLUtils.getReferenceOutputType(reference)) && DomUtils.isDOM(referenceContent)) {
                        referenceIs = referenceContent.openStream();
                        this.writeDigestValueOnCanonicalizedInputStream(digestCalculator, referenceIs, canonicalizationMethod);
                        break block11;
                    }
                    referenceIs = referenceContent.openStream();
                    digestCalculator.update(referenceIs);
                }
                catch (IOException e) {
                    try {
                        throw new DSSException("Cannot build an AllDataObjectsTimestamp : An error occurred on reference extraction", e);
                    }
                    catch (Throwable throwable) {
                        Utils.closeQuietly(referenceIs);
                        throw throwable;
                    }
                }
            }
            Utils.closeQuietly(referenceIs);
        }
        DSSMessageDigest messageDigest = digestCalculator.getMessageDigest(digestAlgorithm);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Computed AllDataObjectsTimestampData data digest: {}", (Object)messageDigest);
        }
        TimestampBinary timeStampResponse = this.tspSource.getTimeStampResponse(digestAlgorithm, messageDigest.getValue());
        try {
            TimestampToken token = new TimestampToken(timeStampResponse.getBytes(), TimestampType.ALL_DATA_OBJECTS_TIMESTAMP);
            token.setCanonicalizationMethod(canonicalizationMethod);
            return token;
        }
        catch (IOException | CMSException | TSPException e) {
            throw new DSSException("Cannot build an AllDataObjectsTimestamp", e);
        }
    }

    private void writeDigestValueOnCanonicalizedInputStream(DSSMessageDigestCalculator messageDigestCalculator, InputStream is, String canonicalizationMethod) throws IOException {
        try (OutputStream os = messageDigestCalculator.getOutputStream();){
            XMLCanonicalizer.createInstance(canonicalizationMethod).canonicalize(is, os);
        }
    }

    private void assertTimestampCreationPossible(List<DSSDocument> documents) {
        for (DSSDocument document : documents) {
            if (!(document instanceof DigestDocument)) continue;
            throw new IllegalArgumentException("Content timestamp creation is not possible with DigestDocument!");
        }
    }
}

