/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SigningOperation;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.validation.executor.CompleteValidationContextExecutor;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESProfileParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.definition.XAdESNamespace;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Attribute;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Element;
import eu.europa.esig.dss.xades.definition.xades122.XAdES122Attribute;
import eu.europa.esig.dss.xades.definition.xades122.XAdES122Element;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.dss.xades.signature.ExtensionBuilder;
import eu.europa.esig.dss.xades.validation.XAdESAttributeIdentifier;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XMLDocumentAnalyzer;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESLevelBaselineT
extends ExtensionBuilder
implements SignatureExtension<XAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESLevelBaselineT.class);
    protected TSPSource tspSource;

    public XAdESLevelBaselineT(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    private void incorporateC14nMethod(Element parentDom, String signedInfoC14nMethod) {
        Element canonicalizationMethodDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.CANONICALIZATION_METHOD);
        canonicalizationMethodDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), signedInfoC14nMethod);
        parentDom.appendChild(canonicalizationMethodDom);
    }

    @Override
    public DSSDocument extendSignatures(DSSDocument dssDocument, XAdESSignatureParameters params) throws DSSException {
        Objects.requireNonNull(dssDocument, "The document cannot be null");
        Objects.requireNonNull(this.tspSource, "The TSPSource cannot be null");
        this.params = params;
        XAdESProfileParameters context = params.getContext();
        if (LOG.isInfoEnabled()) {
            LOG.info("====> Extending: {}", (Object)(dssDocument.getName() == null ? "IN MEMORY DOCUMENT" : dssDocument.getName()));
        }
        this.documentAnalyzer = new XMLDocumentAnalyzer(dssDocument);
        this.documentAnalyzer.setCertificateVerifier(this.certificateVerifier);
        this.documentAnalyzer.setDetachedContents(params.getDetachedContents());
        this.documentAnalyzer.setValidationContextExecutor(CompleteValidationContextExecutor.INSTANCE);
        this.documentDom = this.documentAnalyzer.getRootElement();
        List<AdvancedSignature> signatures = this.documentAnalyzer.getSignatures();
        if (Utils.isCollectionEmpty(signatures)) {
            throw new IllegalInputException("There is no signature to extend!");
        }
        List<AdvancedSignature> signaturesToExtend = signatures;
        SigningOperation operationKind = context.getOperationKind();
        if (SigningOperation.SIGN.equals((Object)operationKind)) {
            String signatureId = params.getDeterministicId();
            for (AdvancedSignature signature : signatures) {
                if (!signatureId.equals(signature.getDAIdentifier())) continue;
                signaturesToExtend = Collections.singletonList(signature);
                break;
            }
        }
        signaturesToExtend = this.assertNoEmbeddedSignaturesPresent(signaturesToExtend);
        this.extendSignatures(signaturesToExtend);
        return this.createXmlDocument();
    }

    private List<AdvancedSignature> assertNoEmbeddedSignaturesPresent(List<AdvancedSignature> signatures) {
        ArrayList<AdvancedSignature> result = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : signatures) {
            XAdESSignature xadesSignature = (XAdESSignature)signature;
            Element signatureElement = xadesSignature.getSignatureElement();
            if (!this.hasSignatureAsParent(signatureElement)) {
                result.add(signature);
                continue;
            }
            LOG.warn("The signature with Id '{}' has a ds:Signature parent within its XML tree! The signature will not be extended.", (Object)signature.getId());
        }
        return result;
    }

    private boolean hasSignatureAsParent(Element element) {
        for (Node parent = element.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!XMLDSigElement.SIGNATURE.isSameTagName(parent.getLocalName()) || !XMLDSigElement.SIGNATURE.getURI().equals(parent.getNamespaceURI())) continue;
            return true;
        }
        return false;
    }

    protected void extendSignatures(List<AdvancedSignature> signatures) {
        List<AdvancedSignature> signaturesToExtend = this.getExtendToTLevelSignatures(signatures);
        if (Utils.isCollectionEmpty(signaturesToExtend)) {
            return;
        }
        SignatureRequirementsChecker signatureRequirementsChecker = this.getSignatureRequirementsChecker();
        signatureRequirementsChecker.assertExtendToTLevelPossible(signatures);
        signatureRequirementsChecker.assertSignaturesValid(signaturesToExtend);
        signatureRequirementsChecker.assertSigningCertificateIsValid(signaturesToExtend);
        for (AdvancedSignature signature : signaturesToExtend) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            Element levelBUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
            XAdESTimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
            DigestAlgorithm digestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
            String canonicalizationMethod = signatureTimestampParameters.getCanonicalizationMethod();
            DSSMessageDigest messageDigest = this.xadesSignature.getTimestampSource().getSignatureTimestampMessageDigest(digestAlgorithm, canonicalizationMethod);
            this.createXAdESTimeStampType(TimestampType.SIGNATURE_TIMESTAMP, canonicalizationMethod, messageDigest);
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelBUnsignedProperties);
        }
    }

    protected SignatureRequirementsChecker getSignatureRequirementsChecker() {
        return new SignatureRequirementsChecker(this.certificateVerifier, this.params);
    }

    private List<AdvancedSignature> getExtendToTLevelSignatures(List<AdvancedSignature> signatures) {
        ArrayList<AdvancedSignature> toBeExtended = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : signatures) {
            if (!this.tLevelExtensionRequired(signature)) continue;
            toBeExtended.add(signature);
        }
        return toBeExtended;
    }

    private boolean tLevelExtensionRequired(AdvancedSignature signature) {
        return SignatureLevel.XAdES_BASELINE_T.equals((Object)this.params.getSignatureLevel()) || !signature.hasTProfile();
    }

    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    protected Element incorporateCertificateValues(Element parentDom, Collection<CertificateToken> certificatesToBeAdded) {
        Element certificateValuesDom = null;
        if (Utils.isCollectionNotEmpty(certificatesToBeAdded)) {
            certificateValuesDom = DomUtils.addElement(this.documentDom, parentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCertificateValues());
            for (CertificateToken certificateToken : certificatesToBeAdded) {
                String base64EncodeCertificate = Utils.toBase64(certificateToken.getEncoded());
                DomUtils.addTextElement(this.documentDom, certificateValuesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementEncapsulatedX509Certificate(), base64EncodeCertificate);
            }
        }
        return certificateValuesDom;
    }

    protected Element incorporateRevocationValues(Element parentDom, Collection<CRLToken> crlsToAdd, Collection<OCSPToken> ocspsToAdd) {
        Element revocationValuesDom = null;
        if (Utils.isCollectionNotEmpty(crlsToAdd) || Utils.isCollectionNotEmpty(ocspsToAdd)) {
            revocationValuesDom = DomUtils.addElement(this.documentDom, parentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementRevocationValues());
            this.incorporateCrlTokens(revocationValuesDom, crlsToAdd);
            this.incorporateOcspTokens(revocationValuesDom, ocspsToAdd);
        }
        return revocationValuesDom;
    }

    private void incorporateCrlTokens(Element parentDom, Collection<CRLToken> crlTokens) {
        if (crlTokens.isEmpty()) {
            return;
        }
        Element crlValuesDom = DomUtils.addElement(this.documentDom, parentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCRLValues());
        for (RevocationToken revocationToken : crlTokens) {
            byte[] encodedCRL = revocationToken.getEncoded();
            String base64EncodedCRL = Utils.toBase64(encodedCRL);
            DomUtils.addTextElement(this.documentDom, crlValuesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementEncapsulatedCRLValue(), base64EncodedCRL);
        }
    }

    private void incorporateOcspTokens(Element parentDom, Collection<OCSPToken> ocspTokens) {
        if (ocspTokens.isEmpty()) {
            return;
        }
        Element ocspValuesDom = DomUtils.addElement(this.documentDom, parentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementOCSPValues());
        for (RevocationToken revocationToken : ocspTokens) {
            byte[] encodedOCSP = revocationToken.getEncoded();
            String base64EncodedOCSP = Utils.toBase64(encodedOCSP);
            DomUtils.addTextElement(this.documentDom, ocspValuesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementEncapsulatedOCSPValue(), base64EncodedOCSP);
        }
    }

    protected void incorporateCertificateValues(Element parentDom, Collection<CertificateToken> certificatesToBeAdded, String indent) {
        Element certificatesDom = this.incorporateCertificateValues(parentDom, certificatesToBeAdded);
        if (certificatesDom != null && indent != null) {
            DomUtils.setTextNode(this.documentDom, parentDom, indent);
            DSSXMLUtils.indentAndReplace(this.documentDom, certificatesDom);
        }
    }

    protected void incorporateRevocationValues(Element parentDom, Collection<CRLToken> crlsToAdd, Collection<OCSPToken> ocspsToAdd, String indent) {
        Element revocationDom = this.incorporateRevocationValues(parentDom, crlsToAdd, ocspsToAdd);
        if (revocationDom != null && indent != null) {
            DomUtils.setTextNode(this.documentDom, parentDom, indent);
            DSSXMLUtils.indentAndReplace(this.documentDom, revocationDom);
        }
    }

    protected String removeOldCertificateValues() {
        String text = null;
        Element toRemove = DomUtils.getElement(this.xadesSignature.getSignatureElement(), this.xadesPath.getCertificateValuesPath());
        if (toRemove != null) {
            text = this.removeNode(toRemove);
            this.xadesSignature.resetCertificateSource();
        }
        return text;
    }

    protected void removeOldRevocationValues() {
        Element toRemove = DomUtils.getElement(this.xadesSignature.getSignatureElement(), this.xadesPath.getRevocationValuesPath());
        if (toRemove != null) {
            this.removeNode(toRemove);
            this.xadesSignature.resetRevocationSources();
        }
    }

    protected String removeLastTimestampAndAnyValidationData() {
        Element toRemove = this.getLastElementIfPresent(XAdES141Element.TIMESTAMP_VALIDATION_DATA, XAdES141Element.ANY_VALIDATION_DATA);
        if (toRemove == null) {
            return null;
        }
        String intent = null;
        while (toRemove != null) {
            intent = this.removeNode(toRemove);
            toRemove = this.getLastElementIfPresent(XAdES141Element.TIMESTAMP_VALIDATION_DATA, XAdES141Element.ANY_VALIDATION_DATA);
        }
        this.xadesSignature.resetCertificateSource();
        this.xadesSignature.resetRevocationSources();
        return intent;
    }

    private Element getLastElementIfPresent(DSSElement ... xadesElements) {
        NodeList nodeList = DomUtils.getNodeList(this.xadesSignature.getSignatureElement(), this.xadesPath.getUnsignedSignaturePropertiesPath() + "/*");
        if (nodeList.getLength() > 0) {
            Element unsignedSignatureElement = (Element)nodeList.item(nodeList.getLength() - 1);
            String nodeName = unsignedSignatureElement.getLocalName();
            if (Arrays.stream(xadesElements).anyMatch(e -> e.isSameTagName(nodeName))) {
                return unsignedSignatureElement;
            }
        }
        return null;
    }

    protected void incorporateTimestampValidationData(ValidationData validationDataForInclusion, String indent) {
        this.incorporateValidationData(validationDataForInclusion, indent, XAdES141Element.TIMESTAMP_VALIDATION_DATA, "tsvd-");
    }

    protected void incorporateAnyValidationData(ValidationData validationDataForInclusion, String indent) {
        this.incorporateValidationData(validationDataForInclusion, indent, XAdES141Element.ANY_VALIDATION_DATA, "avd-");
    }

    protected void incorporateValidationData(ValidationData validationDataForInclusion, String indent, DSSElement element, String prefix) {
        if (!validationDataForInclusion.isEmpty()) {
            Set<CertificateToken> certificateValuesToAdd = validationDataForInclusion.getCertificateTokens();
            Set<CRLToken> crlsToAdd = validationDataForInclusion.getCrlTokens();
            Set<OCSPToken> ocspsToAdd = validationDataForInclusion.getOcspTokens();
            Element timeStampValidationDataDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, this.getXades141Namespace(), element);
            this.incorporateCertificateValues(timeStampValidationDataDom, certificateValuesToAdd, indent);
            this.incorporateRevocationValues(timeStampValidationDataDom, crlsToAdd, ocspsToAdd, indent);
            String id = "1";
            List<TimestampToken> timestamps = this.xadesSignature.getAllTimestamps();
            if (Utils.isCollectionNotEmpty(timestamps)) {
                TimestampToken timestampToken = timestamps.get(timestamps.size() - 1);
                id = this.toXmlIdentifier(timestampToken.getDSSId());
            }
            timeStampValidationDataDom.setAttribute("Id", prefix + id);
            if (this.params.isPrettyPrint()) {
                DSSXMLUtils.indentAndReplace(this.documentDom, timeStampValidationDataDom);
            }
        }
    }

    protected void incorporateArchiveTimestamp() {
        XAdESTimestampParameters archiveTimestampParameters = this.params.getArchiveTimestampParameters();
        DigestAlgorithm digestAlgorithm = archiveTimestampParameters.getDigestAlgorithm();
        String canonicalizationMethod = archiveTimestampParameters.getCanonicalizationMethod();
        DSSMessageDigest messageDigest = this.xadesSignature.getTimestampSource().getArchiveTimestampData(digestAlgorithm, canonicalizationMethod);
        this.createXAdESTimeStampType(TimestampType.ARCHIVE_TIMESTAMP, canonicalizationMethod, messageDigest);
    }

    protected void createXAdESTimeStampType(TimestampType timestampType, String timestampC14nMethod, DSSMessageDigest messageDigest) throws DSSException {
        Element timeStampDom;
        if ((XAdESNamespace.XADES_111.isSameUri(this.getXadesNamespace().getUri()) || XAdESNamespace.XADES_122.isSameUri(this.getXadesNamespace().getUri())) && TimestampType.SIGNATURE_TIMESTAMP != timestampType) {
            throw new UnsupportedOperationException("Signature Timestamp creation is only supported for XAdES 1.1.1 and 1.2.2");
        }
        XAdESTimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
        DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
        switch (timestampType) {
            case SIGNATURE_TIMESTAMP: {
                timeStampDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignatureTimeStamp());
                break;
            }
            case VALIDATION_DATA_TIMESTAMP: {
                if (this.params.isEn319132()) {
                    timeStampDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, this.getXades141Namespace(), XAdES141Element.SIG_AND_REFS_TIMESTAMP_V2);
                    break;
                }
                timeStampDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigAndRefsTimeStamp());
                break;
            }
            case VALIDATION_DATA_REFSONLY_TIMESTAMP: {
                if (this.params.isEn319132()) {
                    timeStampDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, this.getXades141Namespace(), XAdES141Element.REFS_ONLY_TIMESTAMP_V2);
                    break;
                }
                timeStampDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementRefsOnlyTimeStamp());
                break;
            }
            case ARCHIVE_TIMESTAMP: {
                timeStampDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, this.getXades141Namespace(), XAdES141Element.ARCHIVE_TIMESTAMP);
                timestampDigestAlgorithm = this.params.getArchiveTimestampParameters().getDigestAlgorithm();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported timestamp type : " + (Object)((Object)timestampType));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timestamp generation: {} / {} / {}", timestampDigestAlgorithm.getName(), timestampC14nMethod, Utils.toBase64(messageDigest.getValue()));
        }
        TimestampBinary timeStampToken = this.tspSource.getTimeStampResponse(timestampDigestAlgorithm, messageDigest.getValue());
        String base64EncodedTimeStampToken = Utils.toBase64(DSSASN1Utils.getDEREncoded(timeStampToken));
        if (XAdESNamespace.XADES_122.isSameUri(this.getXadesNamespace().getUri())) {
            this.incorporateXAdES122Include(timeStampDom);
        }
        if (XAdESNamespace.XADES_111.isSameUri(this.getXadesNamespace().getUri())) {
            this.incorporateHashDataInfo(timeStampDom, timestampC14nMethod);
        } else {
            this.incorporateC14nMethod(timeStampDom, timestampC14nMethod);
        }
        Element encapsulatedTimeStampDom = DomUtils.addElement(this.documentDom, timeStampDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementEncapsulatedTimeStamp());
        DomUtils.setTextNode(this.documentDom, encapsulatedTimeStampDom, base64EncodedTimeStampToken);
        if (!XAdESNamespace.XADES_111.isSameUri(this.getXadesNamespace().getUri())) {
            String timestampId = this.toXmlIdentifier(XAdESAttributeIdentifier.build(timeStampDom));
            timeStampDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), "ts-" + timestampId);
            encapsulatedTimeStampDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), "ets-" + timestampId);
        }
    }

    private void incorporateHashDataInfo(Element timeStampDom, String timestampC14nMethod) {
        Element hashDataInfoDom = DomUtils.addElement(this.documentDom, timeStampDom, this.getXadesNamespace(), XAdES111Element.HASH_DATA_INFO);
        hashDataInfoDom.setAttribute(XAdES111Attribute.URI.getAttributeName(), '#' + this.xadesSignature.getId());
        Element transformsDom = DomUtils.addElement(this.documentDom, hashDataInfoDom, this.getXadesNamespace(), XAdES111Element.TRANSFORMS);
        Element transformDom = DomUtils.addElement(this.documentDom, transformsDom, this.getXmldsigNamespace(), XMLDSigElement.TRANSFORM);
        transformDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), timestampC14nMethod);
    }

    private void incorporateXAdES122Include(Element timeStampDom) {
        Element includeDom = DomUtils.addElement(this.documentDom, timeStampDom, this.getXadesNamespace(), XAdES122Element.INCLUDE);
        includeDom.setAttribute(XAdES122Attribute.URI.getAttributeName(), '#' + this.xadesSignature.getSignatureValueId());
    }

    protected void assertDetachedDocumentsContainBinaries() {
        List<DSSDocument> detachedContents = this.params.getDetachedContents();
        if (Utils.isCollectionNotEmpty(detachedContents)) {
            for (DSSDocument detachedDocument : detachedContents) {
                if (!(detachedDocument instanceof DigestDocument)) continue;
                throw new IllegalArgumentException("XAdES-LTA requires complete binaries of signed documents! Extension with a DigestDocument is not possible.");
            }
        }
    }
}

