/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.signature.XAdESLevelX;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class XAdESLevelXL
extends XAdESLevelX {
    public XAdESLevelXL(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures) {
        super.extendSignatures(signatures);
        List<AdvancedSignature> signaturesToExtend = this.getExtendToXLLevelSignatures(signatures);
        if (Utils.isCollectionEmpty(signaturesToExtend)) {
            return;
        }
        for (AdvancedSignature signature : signatures) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            this.xadesSignature.resetTimestampSource();
        }
        SignatureRequirementsChecker signatureRequirementsChecker = this.getSignatureRequirementsChecker();
        if (SignatureLevel.XAdES_XL.equals((Object)this.params.getSignatureLevel())) {
            signatureRequirementsChecker.assertExtendToXLLevelPossible(signatures);
        }
        signatureRequirementsChecker.assertSignaturesValid(signaturesToExtend);
        signatureRequirementsChecker.assertCertificateChainValidForXLLevel(signatures);
        ValidationDataContainer validationDataContainer = this.documentAnalyzer.getValidationData(signatures);
        for (AdvancedSignature signature : signatures) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            if (signatureRequirementsChecker.hasALevelOrHigher(signature)) continue;
            String indent = this.removeOldCertificateValues();
            this.removeOldRevocationValues();
            Element levelXUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
            ValidationData validationDataForInclusion = validationDataContainer.getAllValidationDataForSignatureForInclusion(signature);
            Set<CertificateToken> certificateValuesToAdd = validationDataForInclusion.getCertificateTokens();
            Set<CRLToken> crlsToAdd = validationDataForInclusion.getCrlTokens();
            Set<OCSPToken> ocspsToAdd = validationDataForInclusion.getOcspTokens();
            this.incorporateCertificateValues(this.unsignedSignaturePropertiesDom, certificateValuesToAdd, indent);
            this.incorporateRevocationValues(this.unsignedSignaturePropertiesDom, crlsToAdd, ocspsToAdd, indent);
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelXUnsignedProperties);
        }
    }

    private List<AdvancedSignature> getExtendToXLLevelSignatures(List<AdvancedSignature> signatures) {
        ArrayList<AdvancedSignature> signaturesToExtend = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : signatures) {
            if (!this.xlLevelExtensionRequired(signature)) continue;
            signaturesToExtend.add(signature);
        }
        return signaturesToExtend;
    }

    private boolean xlLevelExtensionRequired(AdvancedSignature signature) {
        return SignatureLevel.XAdES_XL.equals((Object)this.params.getSignatureLevel()) || !signature.hasAProfile();
    }
}

