/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.json;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class RFC3339DateUtils {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String[] DATE_TIME_PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX"};

    private RFC3339DateUtils() {
    }

    public static Date getDate(String dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf.parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(String.format("Invalid 'date format': %s", dateString));
        }
    }

    public static Date getDateTime(String dateTimeString) {
        if (dateTimeString == null) {
            return null;
        }
        for (String pattern : DATE_TIME_PATTERNS) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                return sdf.parse(dateTimeString);
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException(String.format("Unparseable 'date-time': %s", dateTimeString));
    }
}

