/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.json;

import com.github.erosb.jsonsKema.Schema;
import com.github.erosb.jsonsKema.SourceLocation;
import com.github.erosb.jsonsKema.ValidationFailure;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class ValidationMessage {
    private final ValidationFailure validationFailure;

    public ValidationMessage(ValidationFailure validationFailure) {
        Objects.requireNonNull(validationFailure, "ValidationFailure cannot be null!");
        this.validationFailure = validationFailure;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        this.append(sb, this.validationFailure);
        return sb.toString();
    }

    private void append(StringBuilder sb, ValidationFailure validationFailure) {
        sb.append(validationFailure.getMessage());
        Set<ValidationFailure> causes = validationFailure.getCauses();
        if (!causes.isEmpty()) {
            sb.append(": causes(");
            Iterator<ValidationFailure> it = causes.iterator();
            while (it.hasNext()) {
                this.append(sb, it.next());
                if (!it.hasNext()) continue;
                sb.append("; ");
            }
            sb.append(")");
            return;
        }
        Schema schema = validationFailure.getSchema();
        if (!schema.subschemas().isEmpty()) {
            this.append(sb, schema);
        } else {
            this.append(sb, validationFailure.getInstance().getLocation());
        }
    }

    private void append(StringBuilder sb, Schema schema) {
        if (!schema.subschemas().isEmpty()) {
            for (Schema subSchema : schema.subschemas()) {
                this.append(sb, subSchema);
            }
        } else {
            sb.append(", ");
            sb.append(schema);
        }
    }

    private void append(StringBuilder sb, SourceLocation location) {
        if (location != null) {
            sb.append(", location: ");
            sb.append(location);
        }
    }
}

