/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.jws;

import eu.europa.esig.jws.AbstractJWSUtils;
import java.net.URI;
import java.util.Map;

public class JWSProtectedHeaderUtils
extends AbstractJWSUtils {
    private static final String JWS_PROTECTED_HEADER_SCHEMA_URI = "rfc7515-protected.json";
    private static final String JWS_PROTECTED_HEADER_SCHEMA_LOCATION = "/schema/rfc7515-protected.json";
    private static JWSProtectedHeaderUtils singleton;

    private JWSProtectedHeaderUtils() {
    }

    public static JWSProtectedHeaderUtils getInstance() {
        if (singleton == null) {
            singleton = new JWSProtectedHeaderUtils();
        }
        return singleton;
    }

    @Override
    public String getSchemaURI() {
        return JWS_PROTECTED_HEADER_SCHEMA_URI;
    }

    @Override
    public Map<URI, String> getSchemaDefinitions() {
        Map<URI, String> definitions = this.getJSONSchemaDefinitions();
        definitions.putAll(this.getRFCDefinitions());
        definitions.put(URI.create(JWS_PROTECTED_HEADER_SCHEMA_URI), JWS_PROTECTED_HEADER_SCHEMA_LOCATION);
        return definitions;
    }
}

