/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.Property;

class RoundFunction
extends FunctionBase {
    RoundFunction() {
    }

    @Override
    public int getRequiredArgsCount() {
        return 1;
    }

    @Override
    public Property eval(Property[] args2, PropertyInfo pInfo) throws PropertyException {
        Number dbl = args2[0].getNumber();
        if (dbl == null) {
            throw new PropertyException("Non number operand to round function");
        }
        double n = dbl.doubleValue();
        double r = Math.floor(n + 0.5);
        if (r == 0.0 && n < 0.0) {
            r = -r;
        }
        return NumberProperty.getInstance(r);
    }
}

