/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.fo.pagination.Title;
import org.apache.fop.layoutmgr.AbstractBaseLayoutManager;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;

public class ContentLayoutManager
extends AbstractBaseLayoutManager
implements InlineLevelLayoutManager {
    private static Log log = LogFactory.getLog(ContentLayoutManager.class);
    private Area holder;
    private int stackSize;
    private LayoutManager parentLM;
    private InlineLevelLayoutManager childLM;

    public ContentLayoutManager(Area area, LayoutManager parentLM) {
        this.holder = area;
        this.parentLM = parentLM;
    }

    public ContentLayoutManager(PageSequenceLayoutManager pslm, Title foTitle) {
        this.parentLM = pslm;
        this.holder = new LineArea();
        this.holder.setChangeBarList(this.getChangeBarList());
        try {
            LayoutManager lm = pslm.getLayoutManagerMaker().makeLayoutManager(foTitle);
            this.addChildLM(lm);
            this.fillArea(lm);
        }
        catch (IllegalStateException e) {
            log.warn("Title has no content");
            throw e;
        }
    }

    @Override
    public void initialize() {
    }

    private void fillArea(LayoutManager curLM) {
        int maxtb;
        int ipd = 1000000;
        LayoutContext childLC = LayoutContext.newInstance();
        childLC.setFlags(1);
        childLC.setLeadingSpace(new SpaceSpecifier(false));
        childLC.setTrailingSpace(new SpaceSpecifier(false));
        childLC.setRefIPD(ipd);
        int lineHeight = 14000;
        int lead = 12000;
        int follow = 2000;
        int halfLeading = (lineHeight - lead - follow) / 2;
        int lineLead = lead + halfLeading;
        int middlefollow = maxtb = follow + halfLeading;
        this.stackSize = 0;
        List<ListElement> contentList = this.getNextKnuthElements(childLC, 135);
        for (ListElement aContentList : contentList) {
            KnuthElement element = (KnuthElement)aContentList;
            if (!(element instanceof KnuthInlineBox)) continue;
            KnuthInlineBox knuthInlineBox = (KnuthInlineBox)element;
        }
        if (maxtb - lineLead > middlefollow) {
            middlefollow = maxtb - lineLead;
        }
        LayoutContext lc = LayoutContext.newInstance();
        lc.setFlags(16, true);
        lc.setLeadingSpace(new SpaceSpecifier(false));
        lc.setTrailingSpace(new SpaceSpecifier(false));
        KnuthPossPosIter contentPosIter = new KnuthPossPosIter(contentList, 0, contentList.size());
        curLM.addAreas(contentPosIter, lc);
    }

    @Override
    public void addAreas(PositionIterator posIter, LayoutContext context) {
        int savedIPD = ((InlineArea)this.holder).getIPD();
        LayoutContext childContext = LayoutContext.copyOf(context);
        childContext.setIPDAdjust(0.0);
        this.childLM.addAreas(posIter, childContext);
        ((InlineArea)this.holder).setIPD(savedIPD);
    }

    public int getStackingSize() {
        return this.stackSize;
    }

    @Override
    public Area getParentArea(Area childArea) {
        return this.holder;
    }

    @Override
    public void addChildArea(Area childArea) {
        this.holder.addChildArea(childArea);
    }

    @Override
    public void setParent(LayoutManager lm) {
        this.parentLM = lm;
    }

    @Override
    public LayoutManager getParent() {
        return this.parentLM;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public void setFinished(boolean isFinished) {
    }

    @Override
    public boolean createNextChildLMs(int pos) {
        return false;
    }

    @Override
    public List<LayoutManager> getChildLMs() {
        ArrayList<LayoutManager> childLMs = new ArrayList<LayoutManager>(1);
        childLMs.add(this.childLM);
        return childLMs;
    }

    @Override
    public void addChildLM(LayoutManager lm) {
        if (lm == null) {
            return;
        }
        lm.setParent(this);
        this.childLM = (InlineLevelLayoutManager)lm;
        log.trace(this.getClass().getName() + ": Adding child LM " + lm.getClass().getName());
    }

    @Override
    public void addChildLMs(List<LayoutManager> newLMs) {
        if (newLMs == null || newLMs.size() == 0) {
            return;
        }
        Iterator<LayoutManager> iterator2 = newLMs.iterator();
        while (iterator2.hasNext()) {
            LayoutManager newLM;
            LayoutManager lm = newLM = iterator2.next();
            this.addChildLM(lm);
        }
    }

    @Override
    public List<ListElement> getNextKnuthElements(LayoutContext context, int alignment) {
        LinkedList<ListElement> contentList = new LinkedList<ListElement>();
        this.childLM.initialize();
        while (!this.childLM.isFinished()) {
            List returnedList = this.childLM.getNextKnuthElements(context, alignment);
            if (returnedList == null) continue;
            while (returnedList.size() > 0) {
                KnuthElement contentElement;
                Object obj = returnedList.remove(0);
                if (obj instanceof KnuthSequence) {
                    KnuthSequence ks = (KnuthSequence)obj;
                    for (Object k : ks) {
                        contentElement = (KnuthElement)k;
                        this.stackSize += contentElement.getWidth();
                        contentList.add(contentElement);
                    }
                    continue;
                }
                contentElement = (KnuthElement)obj;
                this.stackSize += contentElement.getWidth();
                contentList.add(contentElement);
            }
        }
        this.setFinished(true);
        return contentList;
    }

    public List addALetterSpaceTo(List oldList) {
        return oldList;
    }

    public List addALetterSpaceTo(List oldList, int depth) {
        return this.addALetterSpaceTo(oldList);
    }

    @Override
    public String getWordChars(Position pos) {
        return "";
    }

    @Override
    public void hyphenate(Position pos, HyphContext hc) {
    }

    public boolean applyChanges(List oldList) {
        return false;
    }

    public boolean applyChanges(List oldList, int depth) {
        return this.applyChanges(oldList);
    }

    @Override
    public List<ListElement> getChangedKnuthElements(List<ListElement> oldList, int alignment) {
        return null;
    }

    @Override
    public List<ListElement> getChangedKnuthElements(List<ListElement> oldList, int alignment, int depth) {
        return this.getChangedKnuthElements(oldList, alignment);
    }

    @Override
    public PageSequenceLayoutManager getPSLM() {
        return this.parentLM.getPSLM();
    }

    @Override
    public boolean hasLineAreaDescendant() {
        return true;
    }

    @Override
    public int getBaselineOffset() {
        return this.childLM.getBaselineOffset();
    }

    @Override
    public int getContentAreaIPD() {
        return this.holder.getIPD();
    }

    @Override
    public int getContentAreaBPD() {
        return this.holder.getBPD();
    }

    @Override
    public boolean getGeneratesReferenceArea() {
        return false;
    }

    @Override
    public boolean getGeneratesBlockArea() {
        return this.getGeneratesLineArea() || this.holder instanceof Block;
    }

    @Override
    public boolean getGeneratesLineArea() {
        return this.holder instanceof LineArea;
    }

    @Override
    public Position notifyPos(Position pos) {
        return pos;
    }
}

