/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.fontlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.tools.fontlist.FontSpec;

public class FontListGenerator {
    public SortedMap listFonts(FopFactory fopFactory, String mime, FontEventListener listener) throws FOPException {
        FontInfo fontInfo = this.setupFonts(fopFactory, mime, listener);
        SortedMap fontFamilies = this.buildFamilyMap(fontInfo);
        return fontFamilies;
    }

    private FontInfo setupFonts(FopFactory fopFactory, String mime, FontEventListener listener) throws FOPException {
        FOUserAgent userAgent = fopFactory.newFOUserAgent();
        IFDocumentHandler documentHandler = fopFactory.getRendererFactory().createDocumentHandler(userAgent, mime);
        IFDocumentHandlerConfigurator configurator = documentHandler.getConfigurator();
        FontInfo fontInfo = new FontInfo();
        configurator.setupFontInfo(documentHandler.getMimeType(), fontInfo);
        documentHandler.setFontInfo(fontInfo);
        return fontInfo;
    }

    private SortedMap buildFamilyMap(FontInfo fontInfo) {
        Map<String, Typeface> fonts = fontInfo.getFonts();
        HashSet<String> keyBag = new HashSet<String>(fonts.keySet());
        HashMap<String, FontSpec> keys2 = new HashMap<String, FontSpec>();
        TreeMap<String, ArrayList<FontSpec>> fontFamilies = new TreeMap<String, ArrayList<FontSpec>>();
        Iterator<Map.Entry<FontTriplet, String>> iterator2 = fontInfo.getFontTriplets().entrySet().iterator();
        while (iterator2.hasNext()) {
            FontSpec container;
            Map.Entry<FontTriplet, String> o;
            Map.Entry<FontTriplet, String> entry = o = iterator2.next();
            FontTriplet triplet = entry.getKey();
            String key = entry.getValue();
            if (keyBag.contains(key)) {
                keyBag.remove(key);
                FontMetrics metrics = fonts.get(key);
                container = new FontSpec(key, metrics);
                container.addFamilyNames(metrics.getFamilyNames());
                keys2.put(key, container);
                String firstFamilyName = (String)container.getFamilyNames().first();
                ArrayList<FontSpec> containers = (ArrayList<FontSpec>)fontFamilies.get(firstFamilyName);
                if (containers == null) {
                    containers = new ArrayList<FontSpec>();
                    fontFamilies.put(firstFamilyName, containers);
                }
                containers.add(container);
                Collections.sort(containers);
            } else {
                container = (FontSpec)keys2.get(key);
            }
            container.addTriplet(triplet);
        }
        return fontFamilies;
    }
}

