/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfwriter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.COSUpdateInfo;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessInputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdfparser.PDFXRefStream;
import org.apache.pdfbox.pdfparser.xref.FreeXReference;
import org.apache.pdfbox.pdfparser.xref.NormalXReference;
import org.apache.pdfbox.pdfparser.xref.ObjectStreamXReference;
import org.apache.pdfbox.pdfparser.xref.XReferenceEntry;
import org.apache.pdfbox.pdfwriter.COSStandardOutputStream;
import org.apache.pdfbox.pdfwriter.compress.COSWriterCompressionPool;
import org.apache.pdfbox.pdfwriter.compress.COSWriterObjectStream;
import org.apache.pdfbox.pdfwriter.compress.CompressParameters;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.COSFilterInputStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.util.Hex;

public class COSWriter
implements ICOSVisitor {
    public static final byte[] DICT_OPEN = "<<".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] DICT_CLOSE = ">>".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] SPACE = new byte[]{32};
    public static final byte[] COMMENT = new byte[]{37};
    public static final byte[] VERSION = "PDF-1.4".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] GARBAGE = new byte[]{-10, -28, -4, -33};
    public static final byte[] EOF = "%%EOF".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] REFERENCE = "R".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] XREF = "xref".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] XREF_FREE = "f".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] XREF_USED = "n".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] TRAILER = "trailer".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] STARTXREF = "startxref".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] OBJ = "obj".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] ENDOBJ = "endobj".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] ARRAY_OPEN = "[".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] ARRAY_CLOSE = "]".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] STREAM = "stream".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] ENDSTREAM = "endstream".getBytes(StandardCharsets.US_ASCII);
    private static final NumberFormat formatXrefOffset = new DecimalFormat("0000000000", DecimalFormatSymbols.getInstance(Locale.US));
    private static final NumberFormat formatXrefGeneration = new DecimalFormat("00000", DecimalFormatSymbols.getInstance(Locale.US));
    private OutputStream output;
    private COSStandardOutputStream standardOutput;
    private long startxref = 0L;
    private long number = 0L;
    private final Map<COSBase, COSObjectKey> objectKeys = new Hashtable<COSBase, COSObjectKey>();
    private final Map<COSObjectKey, COSBase> keyObject = new HashMap<COSObjectKey, COSBase>();
    private final List<XReferenceEntry> xRefEntries = new ArrayList<XReferenceEntry>();
    private final Deque<COSBase> objectsToWrite = new ArrayDeque<COSBase>();
    private final Set<COSBase> writtenObjects = new HashSet<COSBase>();
    private final Set<COSBase> actualsAdded = new HashSet<COSBase>();
    private COSObjectKey currentObjectKey = null;
    private PDDocument pdDocument = null;
    private FDFDocument fdfDocument = null;
    private boolean willEncrypt = false;
    private boolean incrementalUpdate = false;
    private boolean reachedSignature = false;
    private long signatureOffset;
    private long signatureLength;
    private long byteRangeOffset;
    private long byteRangeLength;
    private RandomAccessRead incrementalInput;
    private OutputStream incrementalOutput;
    private SignatureInterface signatureInterface;
    private byte[] incrementPart;
    private COSArray byteRangeArray;
    private final CompressParameters compressParameters;
    private boolean blockAddingObject = false;

    public COSWriter(OutputStream outputStream) {
        this(outputStream, (CompressParameters)null);
    }

    public COSWriter(OutputStream outputStream, CompressParameters compressParameters) {
        this.setOutput(outputStream);
        this.setStandardOutput(new COSStandardOutputStream(this.output));
        this.compressParameters = compressParameters;
    }

    public COSWriter(OutputStream outputStream, RandomAccessRead inputData) throws IOException {
        this.setOutput(new ByteArrayOutputStream());
        this.setStandardOutput(new COSStandardOutputStream(this.output, inputData.length()));
        this.compressParameters = CompressParameters.NO_COMPRESSION;
        this.incrementalInput = inputData;
        this.incrementalOutput = outputStream;
        this.incrementalUpdate = true;
    }

    public COSWriter(OutputStream outputStream, RandomAccessRead inputData, Set<COSDictionary> objectsToWrite) throws IOException {
        this(outputStream, inputData);
        this.objectsToWrite.addAll(objectsToWrite);
    }

    public boolean isCompress() {
        return this.compressParameters != null && this.compressParameters.isCompress();
    }

    private void prepareIncrement() {
        COSDocument cosDoc = this.pdDocument.getDocument();
        Set<COSObjectKey> keySet = cosDoc.getXrefTable().keySet();
        for (COSObjectKey cosObjectKey : keySet) {
            COSBase object;
            if (cosObjectKey == null || (object = cosDoc.getObjectFromPool(cosObjectKey).getObject()) == null || object instanceof COSNumber) continue;
            this.objectKeys.put(object, cosObjectKey);
            this.keyObject.put(cosObjectKey, object);
        }
    }

    protected void addXRefEntry(XReferenceEntry entry) {
        this.getXRefEntries().add(entry);
    }

    protected OutputStream getOutput() {
        return this.output;
    }

    protected COSStandardOutputStream getStandardOutput() {
        return this.standardOutput;
    }

    protected long getStartxref() {
        return this.startxref;
    }

    protected List<XReferenceEntry> getXRefEntries() {
        return this.xRefEntries;
    }

    private void setOutput(OutputStream newOutput) {
        this.output = newOutput;
    }

    private void setStandardOutput(COSStandardOutputStream newStandardOutput) {
        this.standardOutput = newStandardOutput;
    }

    protected void setStartxref(long newStartxref) {
        this.startxref = newStartxref;
    }

    protected void doWriteBody(COSDocument doc) throws IOException {
        COSDictionary trailer = doc.getTrailer();
        COSBase root = trailer.getItem(COSName.ROOT);
        COSBase info = trailer.getItem(COSName.INFO);
        COSBase encrypt = trailer.getItem(COSName.ENCRYPT);
        if (root != null) {
            this.addObjectToWrite(root);
        }
        if (info != null) {
            this.addObjectToWrite(info);
        }
        this.doWriteObjects();
        this.willEncrypt = false;
        if (encrypt != null) {
            this.addObjectToWrite(encrypt);
        }
        this.doWriteObjects();
    }

    private void doWriteBodyCompressed(COSDocument document) throws IOException {
        COSDictionary trailer = document.getTrailer();
        COSDictionary encrypt = trailer.getCOSDictionary(COSName.ENCRYPT);
        this.blockAddingObject = true;
        boolean bl = this.willEncrypt = encrypt != null;
        if (trailer.containsKey(COSName.ROOT)) {
            COSBase object;
            COSWriterCompressionPool compressionPool = new COSWriterCompressionPool(this.pdDocument, this.compressParameters);
            for (COSObjectKey key : compressionPool.getObjectStreamObjects()) {
                object = compressionPool.getObject(key);
                this.writtenObjects.add(object);
                this.objectKeys.put(object, key);
                this.keyObject.put(key, object);
            }
            for (COSObjectKey key : compressionPool.getTopLevelObjects()) {
                object = compressionPool.getObject(key);
                this.writtenObjects.add(object);
                this.objectKeys.put(object, key);
                this.keyObject.put(key, object);
            }
            this.number = compressionPool.getHighestXRefObjectNumber();
            Iterator<Object> iterator2 = compressionPool.getTopLevelObjects().iterator();
            while (iterator2.hasNext()) {
                COSObjectKey key;
                this.currentObjectKey = key = iterator2.next();
                this.doWriteObject(key, this.keyObject.get(key));
            }
            for (COSWriterObjectStream finalizedObjectStream : compressionPool.createObjectStreams()) {
                COSStream stream = finalizedObjectStream.writeObjectsToStream(document.createCOSStream());
                COSObjectKey objectStreamKey = new COSObjectKey(++this.number, 0);
                COSObject objectStream = new COSObject((COSBase)stream, objectStreamKey);
                int i = 0;
                for (COSObjectKey key : finalizedObjectStream.getPreparedKeys()) {
                    COSBase object2 = compressionPool.getObject(key);
                    this.addXRefEntry(new ObjectStreamXReference(i, key, object2, objectStreamKey));
                    ++i;
                }
                this.currentObjectKey = objectStreamKey;
                this.doWriteObject(objectStreamKey, objectStream);
            }
            this.willEncrypt = false;
            if (encrypt != null) {
                COSObjectKey encryptKey;
                this.currentObjectKey = encryptKey = new COSObjectKey(++this.number, 0);
                this.writtenObjects.add(encrypt);
                this.keyObject.put(encryptKey, encrypt);
                this.objectKeys.put(encrypt, encryptKey);
                this.doWriteObject(encryptKey, encrypt);
            }
            this.blockAddingObject = false;
        }
    }

    private void doWriteObjects() throws IOException {
        while (!this.objectsToWrite.isEmpty()) {
            this.doWriteObject(this.objectsToWrite.removeFirst());
        }
    }

    private void addObjectToWrite(COSBase object) {
        if (this.blockAddingObject) {
            return;
        }
        COSBase actual = object;
        if (actual instanceof COSObject) {
            actual = ((COSObject)actual).getObject();
        }
        if (this.writtenObjects.contains(object) || this.actualsAdded.contains(actual) || this.objectsToWrite.contains(object)) {
            return;
        }
        COSBase cosBase = null;
        COSObjectKey cosObjectKey = null;
        if (actual != null && (cosObjectKey = this.objectKeys.get(actual)) != null) {
            cosBase = this.keyObject.get(cosObjectKey);
            if (!this.isNeedToBeUpdated(object) && !this.isNeedToBeUpdated(cosBase)) {
                return;
            }
        }
        this.objectsToWrite.add(object);
        if (actual != null) {
            this.actualsAdded.add(actual);
        }
    }

    public void doWriteObject(COSObjectKey key, COSBase obj) throws IOException {
        if (obj == null || obj instanceof COSObject && ((COSObject)obj).getObject() == null) {
            return;
        }
        this.addXRefEntry(new NormalXReference(this.getStandardOutput().getPos(), key, obj));
        this.getStandardOutput().write(String.valueOf(key.getNumber()).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(String.valueOf(key.getGeneration()).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(OBJ);
        this.getStandardOutput().writeEOL();
        obj.accept(this);
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(ENDOBJ);
        this.getStandardOutput().writeEOL();
    }

    private boolean isNeedToBeUpdated(COSBase base) {
        if (base instanceof COSUpdateInfo) {
            return ((COSUpdateInfo)((Object)base)).isNeedToBeUpdated();
        }
        return false;
    }

    public void doWriteObject(COSBase obj) throws IOException {
        this.writtenObjects.add(obj);
        this.currentObjectKey = this.getObjectKey(obj);
        this.doWriteObject(this.currentObjectKey, obj);
    }

    protected void doWriteHeader(COSDocument doc) throws IOException {
        if (this.isCompress()) {
            this.pdDocument.setVersion(Math.max(this.pdDocument.getVersion(), 1.6f));
            doc.setVersion(Math.max(doc.getVersion(), 1.6f));
        }
        String headerString = this.fdfDocument != null ? "%FDF-" + doc.getVersion() : "%PDF-" + doc.getVersion();
        this.getStandardOutput().write(headerString.getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(COMMENT);
        this.getStandardOutput().write(GARBAGE);
        this.getStandardOutput().writeEOL();
    }

    protected void doWriteTrailer(COSDocument doc) throws IOException {
        this.getStandardOutput().write(TRAILER);
        this.getStandardOutput().writeEOL();
        COSDictionary trailer = doc.getTrailer();
        if (!this.incrementalUpdate) {
            Collections.sort(this.getXRefEntries());
            XReferenceEntry lastEntry = this.getXRefEntries().get(this.getXRefEntries().size() - 1);
            trailer.setLong(COSName.SIZE, lastEntry.getReferencedKey().getNumber() + 1L);
            trailer.removeItem(COSName.PREV);
        }
        if (!doc.isXRefStream()) {
            trailer.setLong(COSName.SIZE, this.number + 1L);
            trailer.removeItem(COSName.XREF_STM);
        }
        trailer.removeItem(COSName.DOC_CHECKSUM);
        COSArray idArray = trailer.getCOSArray(COSName.ID);
        if (idArray != null) {
            idArray.setDirect(true);
        }
        trailer.accept(this);
    }

    private void doWriteXRefInc(COSDocument doc) throws IOException {
        if (!doc.isXRefStream() || doc.hasHybridXRef() && this.incrementalUpdate) {
            COSDictionary trailer = doc.getTrailer();
            trailer.setLong(COSName.PREV, doc.getStartXref());
            this.doWriteXRefTable();
            this.doWriteTrailer(doc);
        } else {
            PDFXRefStream pdfxRefStream = new PDFXRefStream(doc);
            this.getXRefEntries().forEach(pdfxRefStream::addEntry);
            COSDictionary trailer = doc.getTrailer();
            if (this.incrementalUpdate) {
                trailer.setLong(COSName.PREV, doc.getStartXref());
            } else {
                trailer.removeItem(COSName.PREV);
            }
            pdfxRefStream.addTrailerInfo(trailer);
            pdfxRefStream.setSize(this.number + 2L);
            this.setStartxref(this.getStandardOutput().getPos());
            COSStream stream2 = pdfxRefStream.getStream();
            this.doWriteObject(stream2);
        }
    }

    private void doWriteXRefTable() throws IOException {
        if (!this.incrementalUpdate) {
            this.fillGapsWithFreeEntries();
        } else {
            this.addXRefEntry(FreeXReference.NULL_ENTRY);
        }
        List<XReferenceEntry> tmpXRefEntries = this.getXRefEntries().stream().filter(e -> e instanceof NormalXReference || e instanceof FreeXReference).sorted().collect(Collectors.toList());
        this.setStartxref(this.getStandardOutput().getPos());
        this.getStandardOutput().write(XREF);
        this.getStandardOutput().writeEOL();
        Long[] xRefRanges = this.getXRefRanges(tmpXRefEntries);
        int xRefLength = xRefRanges.length;
        int j = 0;
        if (xRefLength % 2 == 0) {
            for (int x = 0; x < xRefLength; x += 2) {
                long xRefRangeX1 = xRefRanges[x + 1];
                this.writeXrefRange(xRefRanges[x], xRefRangeX1);
                int i = 0;
                while ((long)i < xRefRangeX1) {
                    this.writeXrefEntry(tmpXRefEntries.get(j++));
                    ++i;
                }
            }
        }
    }

    private void fillGapsWithFreeEntries() {
        List normalXReferences = this.getXRefEntries().stream().filter(NormalXReference.class::isInstance).map(NormalXReference.class::cast).sorted().collect(Collectors.toList());
        long last = 0L;
        ArrayList<Long> freeNumbers = new ArrayList<Long>();
        for (NormalXReference entry : normalXReferences) {
            long nr = entry.getReferencedKey().getNumber();
            if (nr != last) {
                for (long i = last; i < nr; ++i) {
                    freeNumbers.add(i);
                }
            }
            last = nr + 1L;
        }
        int numberOfFreeNumbers = freeNumbers.size();
        if (numberOfFreeNumbers == 0) {
            this.addXRefEntry(FreeXReference.NULL_ENTRY);
            return;
        }
        for (int i = 0; i < numberOfFreeNumbers - 1; ++i) {
            this.addXRefEntry(new FreeXReference(new COSObjectKey((Long)freeNumbers.get(i), 65535), (Long)freeNumbers.get(i + 1)));
        }
        this.addXRefEntry(new FreeXReference(new COSObjectKey((Long)freeNumbers.get(numberOfFreeNumbers - 1), 65535), 0L));
        long firstObjectNumber = (Long)freeNumbers.get(0);
        if (firstObjectNumber > 0L) {
            this.addXRefEntry(new FreeXReference(new COSObjectKey(0L, 65535), firstObjectNumber));
        }
    }

    private void doWriteIncrement() throws IOException {
        try (RandomAccessInputStream input = new RandomAccessInputStream(this.incrementalInput);){
            IOUtils.copy(input, this.incrementalOutput);
            this.incrementalOutput.write(((ByteArrayOutputStream)this.output).toByteArray());
        }
    }

    private void doWriteSignature() throws IOException {
        long inLength = this.incrementalInput.length();
        long beforeLength = this.signatureOffset;
        long afterOffset = this.signatureOffset + this.signatureLength;
        long afterLength = this.getStandardOutput().getPos() - (inLength + this.signatureLength) - (this.signatureOffset - inLength);
        String byteRange = "0 " + beforeLength + " " + afterOffset + " " + afterLength + "]";
        this.byteRangeArray.set(0, COSInteger.ZERO);
        this.byteRangeArray.set(1, COSInteger.get(beforeLength));
        this.byteRangeArray.set(2, COSInteger.get(afterOffset));
        this.byteRangeArray.set(3, COSInteger.get(afterLength));
        if ((long)byteRange.length() > this.byteRangeLength) {
            throw new IOException("Can't write new byteRange '" + byteRange + "' not enough space: byteRange.length(): " + byteRange.length() + ", byteRangeLength: " + this.byteRangeLength + ", byteRangeOffset: " + this.byteRangeOffset);
        }
        ByteArrayOutputStream byteOut = (ByteArrayOutputStream)this.output;
        byteOut.flush();
        this.incrementPart = byteOut.toByteArray();
        byte[] byteRangeBytes = byteRange.getBytes(StandardCharsets.ISO_8859_1);
        int i = 0;
        while ((long)i < this.byteRangeLength) {
            this.incrementPart[(int)(this.byteRangeOffset + (long)i - inLength)] = i >= byteRangeBytes.length ? 32 : byteRangeBytes[i];
            ++i;
        }
        if (this.signatureInterface != null) {
            InputStream dataToSign = this.getDataToSign();
            byte[] signatureBytes = this.signatureInterface.sign(dataToSign);
            this.writeExternalSignature(signatureBytes);
        }
    }

    public InputStream getDataToSign() throws IOException {
        if (this.incrementPart == null || this.incrementalInput == null) {
            throw new IllegalStateException("PDF not prepared for signing");
        }
        int incPartSigOffset = (int)(this.signatureOffset - this.incrementalInput.length());
        int afterSigOffset = incPartSigOffset + (int)this.signatureLength;
        int[] range = new int[]{0, incPartSigOffset, afterSigOffset, this.incrementPart.length - afterSigOffset};
        return new SequenceInputStream(new RandomAccessInputStream(this.incrementalInput), new COSFilterInputStream(this.incrementPart, range));
    }

    public void writeExternalSignature(byte[] cmsSignature) throws IOException {
        if (this.incrementPart == null || this.incrementalInput == null) {
            throw new IllegalStateException("PDF not prepared for setting signature");
        }
        byte[] signatureBytes = Hex.getBytes(cmsSignature);
        if ((long)signatureBytes.length > this.signatureLength - 2L) {
            throw new IOException("Can't write signature, not enough space; adjust it with SignatureOptions.setPreferredSignatureSize");
        }
        int incPartSigOffset = (int)(this.signatureOffset - this.incrementalInput.length());
        System.arraycopy(signatureBytes, 0, this.incrementPart, incPartSigOffset + 1, signatureBytes.length);
        IOUtils.copy(new RandomAccessInputStream(this.incrementalInput), this.incrementalOutput);
        this.incrementalOutput.write(this.incrementPart);
        this.incrementPart = null;
    }

    private void writeXrefRange(long x, long y) throws IOException {
        this.getStandardOutput().write(String.valueOf(x).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(String.valueOf(y).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().writeEOL();
    }

    private void writeXrefEntry(XReferenceEntry entry) throws IOException {
        String offset = formatXrefOffset.format(entry.getSecondColumnValue());
        String generation = formatXrefGeneration.format(entry.getThirdColumnValue());
        this.getStandardOutput().write(offset.getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(generation.getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(entry instanceof FreeXReference ? XREF_FREE : XREF_USED);
        this.getStandardOutput().writeCRLF();
    }

    protected Long[] getXRefRanges(List<XReferenceEntry> xRefEntriesList) {
        long last = -2L;
        long count = 1L;
        ArrayList<Long> list = new ArrayList<Long>();
        for (XReferenceEntry entry : xRefEntriesList) {
            long nr = entry.getReferencedKey().getNumber();
            if (nr == last + 1L) {
                ++count;
                last = nr;
                continue;
            }
            if (last == -2L) {
                last = nr;
                continue;
            }
            list.add(last - count + 1L);
            list.add(count);
            last = nr;
            count = 1L;
        }
        if (!xRefEntriesList.isEmpty()) {
            list.add(last - count + 1L);
            list.add(count);
        }
        return list.toArray(new Long[list.size()]);
    }

    private COSObjectKey getObjectKey(COSBase obj) {
        COSBase actual;
        COSObjectKey key = obj.getKey();
        if (obj instanceof COSObject) {
            actual = ((COSObject)obj).getObject();
            if (actual == null) {
                if (key == null) {
                    key = new COSObjectKey(++this.number, 0);
                }
                this.objectKeys.put(obj, key);
                return key;
            }
        } else {
            actual = obj;
        }
        COSObjectKey actualKey = this.objectKeys.computeIfAbsent(actual, k -> new COSObjectKey(++this.number, 0));
        if (key == null || actualKey != null && !key.equals(actualKey)) {
            key = actualKey;
            actual.setKey(actualKey);
            if (obj instanceof COSObject) {
                obj.setKey(key);
                this.objectKeys.put(obj, key);
            }
        }
        return key;
    }

    @Override
    public void visitFromArray(COSArray array) throws IOException {
        int count = 0;
        this.getStandardOutput().write(ARRAY_OPEN);
        Iterator<COSBase> i = array.iterator();
        while (i.hasNext()) {
            COSBase current = i.next();
            if (current instanceof COSDictionary) {
                this.writeDictionary((COSDictionary)current);
            } else if (current instanceof COSArray) {
                this.writeArray((COSArray)current);
            } else if (current instanceof COSObject) {
                this.addObjectToWrite(current);
                this.writeReference(current);
            } else if (current == null) {
                COSNull.NULL.accept(this);
            } else {
                current.accept(this);
            }
            ++count;
            if (!i.hasNext()) continue;
            if (count % 10 == 0) {
                this.getStandardOutput().writeEOL();
                continue;
            }
            this.getStandardOutput().write(SPACE);
        }
        this.getStandardOutput().write(ARRAY_CLOSE);
        this.getStandardOutput().writeEOL();
    }

    private void writeArray(COSArray array) throws IOException {
        if (array.isDirect()) {
            this.visitFromArray(array);
        } else {
            this.addObjectToWrite(array);
            this.writeReference(array);
        }
    }

    private void writeDictionary(COSDictionary dictionary) throws IOException {
        if (dictionary.isDirect()) {
            this.visitFromDictionary(dictionary);
        } else {
            this.addObjectToWrite(dictionary);
            this.writeReference(dictionary);
        }
    }

    @Override
    public void visitFromBoolean(COSBoolean obj) throws IOException {
        obj.writePDF(this.getStandardOutput());
    }

    @Override
    public void visitFromDictionary(COSDictionary obj) throws IOException {
        this.detectPossibleSignature(obj);
        this.getStandardOutput().write(DICT_OPEN);
        this.getStandardOutput().writeEOL();
        for (Map.Entry<COSName, COSBase> entry : obj.entrySet()) {
            COSBase value = entry.getValue();
            if (value == null) continue;
            entry.getKey().accept(this);
            this.getStandardOutput().write(SPACE);
            if (value instanceof COSDictionary) {
                COSDictionary dict = (COSDictionary)value;
                if (!this.incrementalUpdate) {
                    COSBase item = dict.getItem(COSName.XOBJECT);
                    if (item != null && !COSName.XOBJECT.equals(entry.getKey())) {
                        item.setDirect(true);
                    }
                    if ((item = dict.getItem(COSName.RESOURCES)) != null && !COSName.RESOURCES.equals(entry.getKey())) {
                        item.setDirect(true);
                    }
                }
                this.writeDictionary(dict);
            } else if (value instanceof COSObject) {
                this.addObjectToWrite(value);
                this.writeReference(value);
            } else if (this.reachedSignature && COSName.CONTENTS.equals(entry.getKey())) {
                this.signatureOffset = this.getStandardOutput().getPos();
                value.accept(this);
                this.signatureLength = this.getStandardOutput().getPos() - this.signatureOffset;
            } else if (this.reachedSignature && COSName.BYTERANGE.equals(entry.getKey())) {
                this.byteRangeArray = (COSArray)entry.getValue();
                this.byteRangeOffset = this.getStandardOutput().getPos() + 1L;
                value.accept(this);
                this.byteRangeLength = this.getStandardOutput().getPos() - 1L - this.byteRangeOffset;
                this.reachedSignature = false;
            } else if (value instanceof COSArray) {
                this.writeArray((COSArray)value);
            } else {
                value.accept(this);
            }
            this.getStandardOutput().writeEOL();
        }
        this.getStandardOutput().write(DICT_CLOSE);
        this.getStandardOutput().writeEOL();
    }

    private void detectPossibleSignature(COSDictionary obj) throws IOException {
        COSArray byteRange;
        COSBase itemType;
        if (!this.reachedSignature && this.incrementalUpdate && (COSName.SIG.equals(itemType = obj.getItem(COSName.TYPE)) || COSName.DOC_TIME_STAMP.equals(itemType)) && (byteRange = obj.getCOSArray(COSName.BYTERANGE)) != null && byteRange.size() == 4) {
            long br3;
            long br2;
            COSBase base2 = byteRange.get(2);
            COSBase base3 = byteRange.get(3);
            if (base2 instanceof COSInteger && base3 instanceof COSInteger && (br2 = ((COSInteger)base2).longValue()) + (br3 = ((COSInteger)base3).longValue()) > this.incrementalInput.length()) {
                this.reachedSignature = true;
            }
        }
    }

    @Override
    public void visitFromDocument(COSDocument doc) throws IOException {
        if (!this.incrementalUpdate) {
            this.doWriteHeader(doc);
        } else {
            this.getStandardOutput().writeCRLF();
        }
        if (this.isCompress()) {
            this.doWriteBodyCompressed(doc);
        } else {
            this.doWriteBody(doc);
        }
        if (this.incrementalUpdate || doc.isXRefStream()) {
            this.doWriteXRefInc(doc);
        } else {
            this.doWriteXRefTable();
            this.doWriteTrailer(doc);
        }
        this.getStandardOutput().write(STARTXREF);
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(String.valueOf(this.getStartxref()).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(EOF);
        this.getStandardOutput().writeEOL();
        if (this.incrementalUpdate) {
            if (this.signatureOffset == 0L || this.byteRangeOffset == 0L) {
                this.doWriteIncrement();
            } else {
                this.doWriteSignature();
            }
        }
    }

    @Override
    public void visitFromFloat(COSFloat obj) throws IOException {
        obj.writePDF(this.getStandardOutput());
    }

    @Override
    public void visitFromInt(COSInteger obj) throws IOException {
        obj.writePDF(this.getStandardOutput());
    }

    @Override
    public void visitFromName(COSName obj) throws IOException {
        obj.writePDF(this.getStandardOutput());
    }

    @Override
    public void visitFromNull(COSNull obj) throws IOException {
        obj.writePDF(this.getStandardOutput());
    }

    public void writeReference(COSBase obj) throws IOException {
        COSObjectKey key = this.getObjectKey(obj);
        this.getStandardOutput().write(String.valueOf(key.getNumber()).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(String.valueOf(key.getGeneration()).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(REFERENCE);
    }

    @Override
    public void visitFromStream(COSStream obj) throws IOException {
        if (this.willEncrypt) {
            this.pdDocument.getEncryption().getSecurityHandler().encryptStream(obj, this.currentObjectKey.getNumber(), this.currentObjectKey.getGeneration());
        }
        try (InputStream input = null;){
            this.visitFromDictionary(obj);
            this.getStandardOutput().write(STREAM);
            this.getStandardOutput().writeCRLF();
            if (obj.hasData()) {
                input = obj.createRawInputStream();
                IOUtils.copy(input, this.getStandardOutput());
            }
            this.getStandardOutput().writeCRLF();
            this.getStandardOutput().write(ENDSTREAM);
            this.getStandardOutput().writeEOL();
        }
    }

    @Override
    public void visitFromString(COSString obj) throws IOException {
        if (this.willEncrypt) {
            this.pdDocument.getEncryption().getSecurityHandler().encryptString(obj, this.currentObjectKey.getNumber(), this.currentObjectKey.getGeneration());
        }
        COSWriter.writeString(obj, (OutputStream)this.getStandardOutput());
    }

    public void write(COSDocument doc) throws IOException {
        PDDocument pdDoc = new PDDocument(doc);
        this.write(pdDoc);
    }

    public void write(PDDocument doc) throws IOException {
        this.write(doc, null);
    }

    public void write(PDDocument doc, SignatureInterface signInterface) throws IOException {
        COSArray idArray;
        long idTime;
        this.pdDocument = doc;
        COSDocument cosDoc = this.pdDocument.getDocument();
        COSDictionary trailer = cosDoc.getTrailer();
        if (this.incrementalUpdate) {
            trailer.toIncrement().exclude(trailer).forEach(base -> {
                this.objectsToWrite.add((COSBase)base);
                if (base instanceof COSObject) {
                    this.actualsAdded.add(((COSObject)base).getObject());
                } else {
                    this.actualsAdded.add((COSBase)base);
                }
            });
        }
        this.signatureInterface = signInterface;
        this.number = this.pdDocument.getDocument().getHighestXRefObjectNumber();
        if (this.incrementalUpdate) {
            this.prepareIncrement();
        }
        long l = idTime = this.pdDocument.getDocumentId() == null ? System.currentTimeMillis() : this.pdDocument.getDocumentId();
        if (doc.isAllSecurityToBeRemoved()) {
            this.willEncrypt = false;
            trailer.removeItem(COSName.ENCRYPT);
        } else if (this.pdDocument.getEncryption() != null) {
            if (!this.incrementalUpdate) {
                SecurityHandler<ProtectionPolicy> securityHandler = this.pdDocument.getEncryption().getSecurityHandler();
                if (!securityHandler.hasProtectionPolicy()) {
                    throw new IllegalStateException("PDF contains an encryption dictionary, please remove it with setAllSecurityToBeRemoved() or set a protection policy with protect()");
                }
                securityHandler.prepareDocumentForEncryption(this.pdDocument);
            }
            this.willEncrypt = true;
        } else {
            this.willEncrypt = false;
        }
        boolean missingID = true;
        COSBase base2 = trailer.getDictionaryObject(COSName.ID);
        if (base2 instanceof COSArray) {
            idArray = (COSArray)base2;
            if (idArray.size() == 2) {
                missingID = false;
            }
        } else {
            idArray = new COSArray();
        }
        if (missingID || this.incrementalUpdate) {
            MessageDigest sha256;
            try {
                sha256 = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            sha256.update(Long.toString(idTime).getBytes(StandardCharsets.ISO_8859_1));
            COSDictionary info = trailer.getCOSDictionary(COSName.INFO);
            if (info != null) {
                for (COSBase cosBase : info.getValues()) {
                    sha256.update(cosBase.toString().getBytes(StandardCharsets.ISO_8859_1));
                }
            }
            COSString firstID = missingID ? new COSString(sha256.digest()) : (COSString)idArray.get(0);
            COSString secondID = missingID ? firstID : new COSString(sha256.digest());
            idArray = new COSArray();
            idArray.add(firstID);
            idArray.add(secondID);
            trailer.setItem(COSName.ID, (COSBase)idArray);
        }
        cosDoc.accept(this);
        if (!this.incrementalUpdate) {
            cosDoc.setHighestXRefObjectNumber(this.number);
        }
    }

    public void write(FDFDocument doc) throws IOException {
        this.fdfDocument = doc;
        COSDocument cosDoc = this.fdfDocument.getDocument();
        if (this.incrementalUpdate) {
            COSDictionary trailer = cosDoc.getTrailer();
            trailer.toIncrement().exclude(trailer).forEach(this.objectsToWrite::add);
        }
        this.willEncrypt = false;
        cosDoc.accept(this);
    }

    public static void writeString(COSString string, OutputStream output) throws IOException {
        COSWriter.writeString(string.getBytes(), string.getForceHexForm(), output);
    }

    public static void writeString(byte[] bytes, OutputStream output) throws IOException {
        COSWriter.writeString(bytes, false, output);
    }

    private static void writeString(byte[] bytes, boolean forceHex, OutputStream output) throws IOException {
        boolean isASCII = true;
        if (!forceHex) {
            for (byte b : bytes) {
                if (b < 0) {
                    isASCII = false;
                    break;
                }
                if (b != 13 && b != 10) continue;
                isASCII = false;
                break;
            }
        }
        if (isASCII && !forceHex) {
            output.write(40);
            block4: for (byte b : bytes) {
                switch (b) {
                    case 40: 
                    case 41: 
                    case 92: {
                        output.write(92);
                        output.write(b);
                        continue block4;
                    }
                    default: {
                        output.write(b);
                    }
                }
            }
            output.write(41);
        } else {
            output.write(60);
            Hex.writeHexBytes(bytes, output);
            output.write(62);
        }
    }
}

